/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.special;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.methods.Methods;
import org.renjin.primitives.Attributes;
import org.renjin.primitives.S3;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SpecialFunction;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;

public class AssignSlotFunction
extends SpecialFunction {
    public AssignSlotFunction() {
        super("@<-");
    }

    @Override
    public SEXP apply(Context context, Environment rho, FunctionCall call2, PairList args2) {
        String slotName;
        if (args2.length() != 3) {
            throw new EvalException("Expected three arguments", new Object[0]);
        }
        SEXP object2 = context.evaluate((SEXP)args2.getElementAsSEXP(0), rho);
        if (object2 == Null.INSTANCE) {
            throw new EvalException("Cannot set slots on the NULL object", new Object[0]);
        }
        Object which2 = args2.getElementAsSEXP(1);
        if (which2 instanceof Symbol) {
            slotName = ((Symbol)which2).getPrintName();
        } else if (which2 instanceof StringVector) {
            slotName = ((StringVector)which2).getElementAsString(0);
        } else {
            throw new EvalException("invalid type '%s' for slot name", which2.getTypeName());
        }
        Object unevaluatedValue = args2.getElementAsSEXP(2);
        PairList repackagedArgs = PairList.Node.fromArray(new SEXP[]{object2, new StringArrayVector(slotName), unevaluatedValue});
        SEXP genericResult = S3.tryDispatchFromPrimitive(context, rho, call2, this.getName(), object2, repackagedArgs);
        if (genericResult != null) {
            return genericResult;
        }
        SEXP rhs = context.evaluate((SEXP)args2.getElementAsSEXP(2));
        StringVector valueClass = Attributes.getClass(rhs);
        StringVector objectClass = object2.getS3Class();
        FunctionCall checkCall = FunctionCall.newCall(Symbol.get("checkAtAssignment"), objectClass, new StringArrayVector(slotName), valueClass);
        context.evaluate(checkCall, rho);
        return Methods.R_set_slot(context, object2, slotName, rhs);
    }
}

