/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Current;
import org.renjin.primitives.io.connections.Connection;
import org.renjin.primitives.io.connections.Connections;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Logical;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;
import org.renjin.utils.ColumnPrinter;
import org.renjin.utils.DoublePrinter;
import org.renjin.utils.FactorPrinter;
import org.renjin.utils.IntPrinter;
import org.renjin.utils.LogicalPrinter;
import org.renjin.utils.StringPrinter;

public class WriteTable {
    public static void write(@Current Context context, ListVector dataFrame, SEXP connHandle, int numRows, int numColumns, Vector rowNames, String sep, String eol, String na2, String dec, SEXP quote, SEXP quoteMethod) throws IOException {
        int i;
        Connection connection2 = Connections.getConnection(context, connHandle);
        PrintWriter writer = connection2.getPrintWriter();
        ArrayList<ColumnPrinter> printers = Lists.newArrayList();
        if (rowNames != Null.INSTANCE) {
            printers.add(new StringPrinter(writer, (StringVector)rowNames, WriteTable.isColumnQuoted(quote, 0), na2));
        }
        for (i = 0; i < dataFrame.length(); ++i) {
            SEXP column = dataFrame.getElementAsSEXP(i);
            if (column instanceof StringVector) {
                printers.add(new StringPrinter(writer, (StringVector)column, WriteTable.isColumnQuoted(quote, i), na2));
                continue;
            }
            if (column instanceof IntVector) {
                if (column.inherits("factor")) {
                    printers.add(new FactorPrinter(writer, (IntVector)column, WriteTable.isColumnQuoted(quote, i), na2));
                    continue;
                }
                printers.add(new IntPrinter(writer, (IntVector)column, na2));
                continue;
            }
            if (column instanceof DoubleVector) {
                printers.add(new DoublePrinter(writer, (DoubleVector)column, dec, na2));
                continue;
            }
            if (column instanceof LogicalVector) {
                printers.add(new LogicalPrinter(writer, (LogicalVector)column, na2));
                continue;
            }
            throw new EvalException("Unsupported column type " + column.getTypeName(), new Object[0]);
        }
        for (i = 0; i != numRows; ++i) {
            for (int j = 0; j != printers.size(); ++j) {
                if (j > 0) {
                    writer.print(sep);
                }
                ((ColumnPrinter)printers.get(j)).print(i);
            }
            writer.print(eol);
        }
    }

    private static boolean isColumnQuoted(SEXP quote, int index) {
        if (quote instanceof LogicalVector) {
            return ((LogicalVector)quote).getElementAsLogical(0) == Logical.TRUE;
        }
        if (quote instanceof IntVector) {
            int[] columns = ((IntVector)quote).toIntArray();
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i] != index + 1) continue;
                return true;
            }
        }
        return false;
    }
}

