/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.pipeline;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import org.renjin.compiler.pipeline.DeferredGraph;
import org.renjin.compiler.pipeline.DeferredNode;
import org.renjin.compiler.pipeline.DeferredNodeComputer;
import org.renjin.compiler.pipeline.VectorPipeliner;
import org.renjin.eval.Profiler;
import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.repackaged.guava.collect.HashMultimap;
import org.renjin.repackaged.guava.collect.Multimap;
import org.renjin.repackaged.guava.collect.Sets;
import org.renjin.sexp.Vector;

public class MultiThreadedVectorPipeliner
implements VectorPipeliner {
    private final ExecutorService executorService;

    public MultiThreadedVectorPipeliner(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public Vector materialize(DeferredComputation root) {
        long start = System.nanoTime();
        DeferredGraph graph = new DeferredGraph(root);
        if (VectorPipeliner.DEBUG) {
            graph.dumpGraph();
        }
        try {
            this.forceMemoizedValues(graph);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        if (Profiler.ENABLED) {
            long time2 = System.nanoTime() - start;
            Profiler.materialized(time2);
        }
        return root;
    }

    @Override
    public Vector simplify(DeferredComputation root) {
        DeferredGraph graph = new DeferredGraph(root);
        if (VectorPipeliner.DEBUG) {
            System.err.println("simplify");
            graph.dumpGraph();
        }
        return this.materialize(root);
    }

    private void forceMemoizedValues(DeferredGraph graph) throws InterruptedException, ExecutionException {
        HashMultimap<DeferredNode, DeferredNode> dependencies = HashMultimap.create();
        this.findDependencies(graph.getRoot(), graph.getRoot(), dependencies);
        HashSet<DeferredNode> toCompute = Sets.newHashSet();
        for (DeferredNode node : graph.getNodes()) {
            if (!node.isMemoized()) continue;
            toCompute.add(node);
        }
        ExecutorCompletionService<DeferredNode> service = new ExecutorCompletionService<DeferredNode>(this.executorService);
        for (int running = 0; !toCompute.isEmpty() || running > 0; --running) {
            Iterator it = toCompute.iterator();
            while (it.hasNext()) {
                DeferredNode node = (DeferredNode)it.next();
                if (!this.allComputed(dependencies.get(node))) continue;
                if (VectorPipeliner.DEBUG) {
                    System.out.println("Starting " + node);
                }
                service.submit(new DeferredNodeComputer(node), node);
                ++running;
                it.remove();
            }
            DeferredNode computed = (DeferredNode)service.take().get();
            if (!VectorPipeliner.DEBUG) continue;
            System.out.println("Completed " + computed);
        }
    }

    private boolean allComputed(Collection<DeferredNode> deferredNodes) {
        for (DeferredNode node : deferredNodes) {
            if (node.isComputed()) continue;
            return false;
        }
        return true;
    }

    private void findDependencies(DeferredNode parentMemo, DeferredNode node, Multimap<DeferredNode, DeferredNode> dependencies) {
        for (DeferredNode child : node.getOperands()) {
            if (child.isMemoized()) {
                dependencies.put(parentMemo, child);
                this.findDependencies(child, child, dependencies);
                continue;
            }
            if (!child.isComputation()) continue;
            this.findDependencies(parentMemo, child, dependencies);
        }
    }
}

