/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.script;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import org.renjin.invoke.reflection.converters.Converters;
import org.renjin.repackaged.guava.base.Function;
import org.renjin.repackaged.guava.collect.Collections2;
import org.renjin.repackaged.guava.collect.Sets;
import org.renjin.sexp.Frame;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;

public class RenjinBindings
implements Bindings {
    private final Frame frame;

    public RenjinBindings(Frame frame2) {
        this.frame = frame2;
    }

    @Override
    public void clear() {
        this.frame.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        for (Symbol symbol2 : this.frame.getSymbols()) {
            if (!this.frame.getVariable(symbol2).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException("nyi");
    }

    @Override
    public boolean isEmpty() {
        return this.frame.getSymbols().isEmpty();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> names2 = Sets.newHashSet();
        for (Symbol symbol2 : this.frame.getSymbols()) {
            names2.add(symbol2.getPrintName());
        }
        return names2;
    }

    @Override
    public int size() {
        return this.frame.getSymbols().size();
    }

    @Override
    public Collection<Object> values() {
        return Collections2.transform(this.frame.getSymbols(), new Function<Symbol, Object>(){

            @Override
            public Object apply(Symbol symbol2) {
                return RenjinBindings.this.frame.getVariable(symbol2);
            }
        });
    }

    @Override
    public boolean containsKey(Object key) {
        return this.frame.getSymbols().contains(this.toSymbol(key));
    }

    @Override
    public Object get(Object key) {
        return this.frame.getVariable(this.toSymbol(key));
    }

    private Symbol toSymbol(Object key) {
        if (key instanceof Symbol) {
            return (Symbol)key;
        }
        if (key instanceof String) {
            return Symbol.get((String)key);
        }
        return Symbol.UNBOUND_VALUE;
    }

    @Override
    public Object put(String name, Object value) {
        Symbol symbol2 = Symbol.get(name);
        SEXP previousValue = this.frame.getVariable(symbol2);
        SEXP exp2 = value == null ? Null.INSTANCE : Converters.get(value.getClass()).convertToR(value);
        this.frame.setVariable(symbol2, exp2);
        return previousValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> toMerge) {
        for (Map.Entry<? extends String, ? extends Object> entry : toMerge.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        Object originalValue = this.get(key);
        this.frame.remove(this.toSymbol(key));
        return originalValue;
    }
}

