/*
 * Decompiled with CFR 0.152.
 */
package com.github.fommil.jni;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JniLoader {
    private static final Logger log = Logger.getLogger(JniLoader.class.getName());
    public static final String JNI_EXTRACT_DIR_PROP = "com.github.fommil.jni.dir";
    private static final Set<String> loaded = new HashSet<String>();

    public static synchronized void load(String ... paths) {
        if (paths == null || paths.length == 0) {
            throw new ExceptionInInitializerError("invalid parameters");
        }
        for (String path2 : paths) {
            String key = new File(path2).getName();
            if (!loaded.contains(key)) continue;
            log.info("already loaded " + path2);
            return;
        }
        String[] javaLibPath = System.getProperty("java.library.path").split(File.pathSeparator);
        for (String path3 : paths) {
            log.config("JNI LIB = " + path3);
            for (String libPath : javaLibPath) {
                File file2 = new File(libPath, path3).getAbsoluteFile();
                log.finest("checking " + file2);
                if (!file2.exists() || !file2.isFile() || !JniLoader.liberalLoad(file2, path3)) continue;
                return;
            }
            File extracted = JniLoader.extract(path3);
            if (extracted == null || !JniLoader.liberalLoad(extracted, path3)) continue;
            return;
        }
        throw new ExceptionInInitializerError("unable to load from " + Arrays.toString(paths));
    }

    private static boolean liberalLoad(File file2, String name) {
        try {
            log.finest("attempting to load " + file2);
            System.load(file2.getAbsolutePath());
            log.info("successfully loaded " + file2);
            loaded.add(name);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            log.log(Level.FINE, "skipping load of " + file2, e);
            String tmpdir = System.getProperty("java.io.tmpdir");
            if (tmpdir != null && tmpdir.trim().length() > 2 && file2.getAbsolutePath().startsWith(tmpdir)) {
                log.log(Level.FINE, "deleting " + file2);
                try {
                    file2.delete();
                }
                catch (Exception e2) {
                    log.info("failed to delete " + file2);
                }
            }
            return false;
        }
        catch (SecurityException e) {
            log.log(Level.INFO, "skipping load of " + file2, e);
            return false;
        }
        catch (Throwable e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static File extract(String path2) {
        try {
            long start = System.currentTimeMillis();
            URL url2 = JniLoader.class.getResource("/" + path2);
            if (url2 == null) {
                return null;
            }
            log.fine("attempting to extract " + url2);
            InputStream in = JniLoader.class.getResourceAsStream("/" + path2);
            try {
                File file2;
                block12: {
                    File file3 = JniLoader.file(path2);
                    JniLoader.deleteOnExit(file3);
                    log.config("extracting " + url2 + " to " + file3.getAbsoluteFile());
                    ReadableByteChannel src = Channels.newChannel(in);
                    FileChannel dest = new FileOutputStream(file3).getChannel();
                    try {
                        dest.transferFrom(src, 0L, Long.MAX_VALUE);
                        long end = System.currentTimeMillis();
                        log.fine("extracted " + path2 + " in " + (end - start) + " millis");
                        file2 = file3;
                        if (Collections.singletonList(dest).get(0) == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (Collections.singletonList(dest).get(0) != null) {
                            dest.close();
                        }
                        throw throwable;
                    }
                    dest.close();
                }
                return file2;
            }
            finally {
                if (Collections.singletonList(in).get(0) != null) {
                    in.close();
                }
            }
        }
        catch (Throwable e) {
            if (e instanceof SecurityException || e instanceof IOException) {
                log.log(Level.CONFIG, "skipping extraction of " + path2, e);
                return null;
            }
            throw new ExceptionInInitializerError(e);
        }
    }

    private static File file(String path2) throws IOException {
        String name = new File(path2).getName();
        String dir2 = System.getProperty(JNI_EXTRACT_DIR_PROP);
        if (dir2 == null) {
            return File.createTempFile("jniloader", name);
        }
        File file2 = new File(dir2, name);
        if (file2.exists() && !file2.isFile()) {
            throw new IllegalArgumentException(file2.getAbsolutePath() + " is not a file.");
        }
        if (!file2.exists()) {
            file2.createNewFile();
        }
        return file2;
    }

    private static void deleteOnExit(File file2) {
        try {
            file2.deleteOnExit();
        }
        catch (Exception e1) {
            log.log(Level.INFO, file2.getAbsolutePath() + " delete denied, retrying - might be Java bug #6997203.");
            try {
                System.gc();
                Thread.yield();
                file2.deleteOnExit();
            }
            catch (Exception e2) {
                log.log(Level.WARNING, file2.getAbsolutePath() + " delete denied a second time.", e2);
            }
        }
    }

    private JniLoader() {
    }
}

