/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.random;

import java.io.Serializable;
import org.apache.commons.math.random.BitsStreamGenerator;

public abstract class AbstractWell
extends BitsStreamGenerator
implements Serializable {
    private static final long serialVersionUID = -817701723016583596L;
    protected int index;
    protected final int[] v;
    protected final int[] iRm1;
    protected final int[] iRm2;
    protected final int[] i1;
    protected final int[] i2;
    protected final int[] i3;

    protected AbstractWell(int k, int m1, int m2, int m3) {
        this(k, m1, m2, m3, System.currentTimeMillis());
    }

    protected AbstractWell(int k, int m1, int m2, int m3, int seed2) {
        this(k, m1, m2, m3, new int[]{seed2});
    }

    protected AbstractWell(int k, int m1, int m2, int m3, int[] seed2) {
        int w = 32;
        int r = (k + 32 - 1) / 32;
        this.v = new int[r];
        this.index = 0;
        this.iRm1 = new int[r];
        this.iRm2 = new int[r];
        this.i1 = new int[r];
        this.i2 = new int[r];
        this.i3 = new int[r];
        for (int j = 0; j < r; ++j) {
            this.iRm1[j] = (j + r - 1) % r;
            this.iRm2[j] = (j + r - 2) % r;
            this.i1[j] = (j + m1) % r;
            this.i2[j] = (j + m2) % r;
            this.i3[j] = (j + m3) % r;
        }
        this.setSeed(seed2);
    }

    protected AbstractWell(int k, int m1, int m2, int m3, long seed2) {
        this(k, m1, m2, m3, new int[]{(int)(seed2 >>> 32), (int)(seed2 & 0xFFFFFFFFL)});
    }

    public void setSeed(int seed2) {
        this.setSeed(new int[]{seed2});
    }

    public void setSeed(int[] seed2) {
        if (seed2 == null) {
            this.setSeed(System.currentTimeMillis());
            return;
        }
        System.arraycopy(seed2, 0, this.v, 0, Math.min(seed2.length, this.v.length));
        if (seed2.length < this.v.length) {
            for (int i = seed2.length; i < this.v.length; ++i) {
                long l = this.v[i - seed2.length];
                this.v[i] = (int)(1812433253L * (l ^ l >> 30) + (long)i & 0xFFFFFFFFL);
            }
        }
        this.index = 0;
    }

    public void setSeed(long seed2) {
        this.setSeed(new int[]{(int)(seed2 >>> 32), (int)(seed2 & 0xFFFFFFFFL)});
    }

    protected abstract int next(int var1);
}

