/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.bzip2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.bzip2.CBZip2InputStream;
import org.apache.commons.vfs2.provider.bzip2.CBZip2OutputStream;
import org.apache.commons.vfs2.provider.compressed.CompressedFileFileObject;
import org.apache.commons.vfs2.provider.compressed.CompressedFileFileSystem;

public class Bzip2FileObject
extends CompressedFileFileObject {
    protected Bzip2FileObject(AbstractFileName name, FileObject container, CompressedFileFileSystem fs) {
        super(name, container, fs);
    }

    protected InputStream doGetInputStream() throws Exception {
        InputStream is2 = this.getContainer().getContent().getInputStream();
        return Bzip2FileObject.wrapInputStream(this.getName().getURI(), is2);
    }

    public static InputStream wrapInputStream(String name, InputStream is2) throws IOException {
        int b1 = is2.read();
        int b2 = is2.read();
        if (b1 != 66 || b2 != 90) {
            throw new FileSystemException("vfs.provider.compressedFile/not-a-compressedFile-file.error", name);
        }
        return new CBZip2InputStream(is2);
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        OutputStream os = this.getContainer().getContent().getOutputStream(false);
        os.write(66);
        os.write(90);
        return new CBZip2OutputStream(os);
    }
}

