/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.tasks;

import java.util.StringTokenizer;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.tasks.VfsTask;
import org.apache.commons.vfs2.util.Messages;
import org.apache.tools.ant.BuildException;

public class DeleteTask
extends VfsTask {
    private String file;
    private String srcDirUrl;
    private String filesList;

    public void setFile(String file2) {
        this.file = file2;
    }

    public void setSrcDir(String srcDir) {
        this.srcDirUrl = srcDir;
    }

    public void setIncludes(String filesList) {
        this.filesList = filesList;
    }

    public void execute() throws BuildException {
        if (this.file == null && this.srcDirUrl == null || this.srcDirUrl != null && this.filesList == null) {
            String message = Messages.getString("vfs.tasks/delete.no-source-files.error");
            throw new BuildException(message);
        }
        try {
            if (this.srcDirUrl != null && this.filesList != null) {
                this.log("Deleting " + this.filesList + " in the directory " + this.srcDirUrl);
                if (!this.srcDirUrl.endsWith("/")) {
                    this.srcDirUrl = this.srcDirUrl + "/";
                }
                StringTokenizer tok = new StringTokenizer(this.filesList, ", \t\n\r\f", false);
                while (tok.hasMoreTokens()) {
                    String nextFile = tok.nextToken();
                    FileObject srcFile = this.resolveFile(this.srcDirUrl + nextFile);
                    srcFile.delete(Selectors.SELECT_ALL);
                }
            } else {
                FileObject srcFile = this.resolveFile(this.file);
                this.log("Deleting " + srcFile);
                srcFile.delete(Selectors.SELECT_ALL);
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }
}

