/*
 * Decompiled with CFR 0.152.
 */
package org.j_paine.formatter;

import java.io.StringBufferInputStream;
import org.j_paine.formatter.CJFormat;
import org.j_paine.formatter.FormatIOElement;
import org.j_paine.formatter.FormatInputList;
import org.j_paine.formatter.IllegalObjectOnWriteException;
import org.j_paine.formatter.InputStreamAndBuffer;
import org.j_paine.formatter.InvalidNumberOnReadException;
import org.j_paine.formatter.NumberParser;
import org.j_paine.formatter.NumberTooWideOnWriteException;
import org.j_paine.formatter.ParseException;
import org.j_paine.formatter.Parsers;
import org.j_paine.formatter.TokenMgrError;

class FormatF
extends FormatIOElement {
    private int d;

    public FormatF(int n, int n2) {
        this.setWidth(n);
        this.d = n2;
    }

    String convertToString(Object object2, int n) throws IllegalObjectOnWriteException, NumberTooWideOnWriteException {
        if (object2 instanceof Integer || object2 instanceof Long || object2 instanceof Float || object2 instanceof Double) {
            CJFormat cJFormat = new CJFormat();
            cJFormat.setWidth(this.getWidth());
            cJFormat.setPrecision(this.d);
            cJFormat.setPre("");
            cJFormat.setPost("");
            cJFormat.setLeadingZeroes(false);
            cJFormat.setShowPlus(false);
            cJFormat.setAlternate(false);
            cJFormat.setShowSpace(false);
            cJFormat.setLeftAlign(false);
            cJFormat.setFmt('f');
            String string = cJFormat.form(((Number)object2).doubleValue());
            if (string.length() > this.getWidth()) {
                throw new NumberTooWideOnWriteException((Number)object2, n, this.toString());
            }
            return string;
        }
        throw new IllegalObjectOnWriteException(object2, n, this.toString());
    }

    Object convertFromString(String string, FormatInputList formatInputList, InputStreamAndBuffer inputStreamAndBuffer) throws InvalidNumberOnReadException {
        NumberParser numberParser = Parsers.theParsers().number_parser;
        numberParser.ReInit(new StringBufferInputStream(string));
        try {
            int n = numberParser.Float();
            Double d = new Double(string.substring(n));
            return d;
        }
        catch (ParseException parseException) {
            throw new InvalidNumberOnReadException(string, formatInputList.getPtr(), this.toString(), inputStreamAndBuffer.getLineErrorReport(), parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidNumberOnReadException(string, formatInputList.getPtr(), this.toString(), inputStreamAndBuffer.getLineErrorReport(), tokenMgrError.getMessage());
        }
    }

    public String toString() {
        return "F" + this.getWidth() + "." + this.d;
    }
}

