/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.statements;

import java.util.Arrays;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.codegen.VariableStorage;
import org.renjin.compiler.ir.tac.IRLabel;
import org.renjin.compiler.ir.tac.expressions.CmpGE;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.LValue;
import org.renjin.compiler.ir.tac.statements.BasicBlockEndingStatement;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.compiler.ir.tac.statements.StatementVisitor;
import org.renjin.eval.EvalException;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.Logical;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.SEXP;

public class IfStatement
implements Statement,
BasicBlockEndingStatement {
    private Expression condition;
    private IRLabel trueTarget;
    private IRLabel falseTarget;
    private IRLabel naTarget;

    public IfStatement(Expression condition, IRLabel trueTarget, IRLabel falseTarget, IRLabel naTarget) {
        this.condition = condition;
        this.trueTarget = trueTarget;
        this.falseTarget = falseTarget;
        this.naTarget = naTarget;
    }

    public IfStatement(Expression condition, IRLabel trueTarget, IRLabel falseTarget) {
        this.condition = condition;
        this.trueTarget = trueTarget;
        this.falseTarget = falseTarget;
        this.naTarget = null;
    }

    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public Expression getRHS() {
        return this.condition;
    }

    public IRLabel getTrueTarget() {
        return this.trueTarget;
    }

    public IRLabel getFalseTarget() {
        return this.falseTarget;
    }

    public IfStatement setTrueTarget(IRLabel label) {
        return new IfStatement(this.condition, label, this.falseTarget, this.naTarget);
    }

    public IfStatement setFalseTarget(IRLabel label) {
        return new IfStatement(this.condition, this.trueTarget, label, this.naTarget);
    }

    @Override
    public Iterable<IRLabel> possibleTargets() {
        if (this.naTarget == null) {
            return Arrays.asList(this.trueTarget, this.falseTarget);
        }
        return Arrays.asList(this.trueTarget, this.falseTarget, this.naTarget);
    }

    @Override
    public void setRHS(Expression newRHS) {
        this.condition = newRHS;
    }

    private Logical toLogical(Object obj) {
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? Logical.TRUE : Logical.FALSE;
        }
        if (obj instanceof SEXP) {
            SEXP s = (SEXP)obj;
            if (s.length() == 0) {
                throw new EvalException("argument is of length zero", new Object[0]);
            }
            if (s instanceof DoubleVector || s instanceof ComplexVector || s instanceof IntVector || s instanceof LogicalVector) {
                return ((SEXP)obj).asLogical();
            }
        }
        throw new EvalException("invalid type where logical expected", new Object[0]);
    }

    public String toString() {
        return "if " + this.condition + " => TRUE:" + this.trueTarget + ", FALSE:" + this.falseTarget + ", NA:" + (this.naTarget == null ? "ERROR" : this.naTarget);
    }

    @Override
    public void setChild(int childIndex, Expression child) {
        if (childIndex != 0) {
            throw new IllegalArgumentException();
        }
        this.condition = child;
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public Expression childAt(int index) {
        if (index == 0) {
            return this.condition;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void accept(StatementVisitor visitor) {
        visitor.visitIf(this);
    }

    @Override
    public int emit(EmitContext emitContext, InstructionAdapter mv) {
        int stackSizeIncrease = 0;
        if (this.condition instanceof CmpGE) {
            CmpGE cmp = (CmpGE)this.getCondition();
            stackSizeIncrease = cmp.childAt(0).load(emitContext, mv) + cmp.childAt(1).load(emitContext, mv);
            mv.visitJumpInsn(161, emitContext.getAsmLabel(this.falseTarget));
            mv.visitJumpInsn(167, emitContext.getAsmLabel(this.trueTarget));
        } else if (this.condition instanceof LValue) {
            VariableStorage storage = emitContext.getVariableStorage((LValue)this.condition);
            if (storage.getType().equals(Type.BOOLEAN_TYPE) || storage.getType().equals(Type.INT_TYPE)) {
                mv.visitVarInsn(21, storage.getSlotIndex());
                mv.visitJumpInsn(153, emitContext.getAsmLabel(this.trueTarget));
                mv.visitJumpInsn(167, emitContext.getAsmLabel(this.falseTarget));
            } else {
                throw new UnsupportedOperationException("TODO: " + storage.getType());
            }
        }
        return stackSizeIncrease;
    }
}

