/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.codegen;

import com.sun.codemodel.JArrayCompRef;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JForLoop;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.math.complex.Complex;
import org.renjin.invoke.annotations.AllowNull;
import org.renjin.invoke.annotations.PreserveAttributeStyle;
import org.renjin.invoke.codegen.ArgumentException;
import org.renjin.invoke.codegen.DeferredVectorBuilder;
import org.renjin.invoke.codegen.scalars.BooleanType;
import org.renjin.invoke.codegen.scalars.DoubleType;
import org.renjin.invoke.codegen.scalars.IntegerType;
import org.renjin.invoke.codegen.scalars.ScalarType;
import org.renjin.invoke.codegen.scalars.ScalarTypes;
import org.renjin.invoke.model.JvmMethod;
import org.renjin.invoke.model.PrimitiveModel;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.Null;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class RecycleLoopBuilder {
    private JCodeModel codeModel;
    private JBlock parent;
    private PrimitiveModel primitive;
    private JvmMethod overload;
    private final JExpression contextVar;
    private List<RecycledArgument> recycledArguments = Lists.newArrayList();
    private Map<JvmMethod.Argument, JExpression> argumentMap = Maps.newHashMap();
    private JVar cycleCount;
    private JVar cycleIndex;
    private ScalarType resultType;
    private boolean useArray;
    private JVar builder;

    public RecycleLoopBuilder(JCodeModel codeModel, JBlock parent2, JExpression contextVar, PrimitiveModel primitive2, JvmMethod overload, Map<JvmMethod.Argument, JExpression> argumentMap) {
        this.codeModel = codeModel;
        this.parent = parent2;
        this.contextVar = contextVar;
        this.primitive = primitive2;
        this.overload = overload;
        this.resultType = ScalarTypes.get(overload.getReturnType());
        for (JvmMethod.Argument argument : overload.getAllArguments()) {
            if (argument.isRecycle()) {
                RecycledArgument recycledArgument = new RecycledArgument(argument, argumentMap.get(argument));
                this.recycledArguments.add(recycledArgument);
                this.argumentMap.put(argument, recycledArgument.getCurrentElement());
                continue;
            }
            this.argumentMap.put(argument, argumentMap.get(argument));
        }
        this.useArray = this.recycledArguments.size() <= 2 && (this.resultType instanceof DoubleType || this.resultType instanceof IntegerType || this.resultType instanceof BooleanType);
    }

    public void build() {
        this.computeResultLength();
        this.initializeBuilder();
        this.loop();
        if (!this.useArray) {
            this.copyAttributesUsingBuilder();
        }
        this.parent._return(this.buildResult());
    }

    private void computeResultLength() {
        this.cycleCount = this.parent.decl(this.codeModel._ref(Integer.TYPE), "cycles");
        if (this.recycledArguments.size() == 1) {
            if (this.recycledArguments.get(0).formal.getAnnotation(AllowNull.class) == null) {
                this.parent._if(this.recycledArguments.get(0).sexp.eq(this.codeModel.ref(Null.class).staticRef("INSTANCE")))._then()._throw(JExpr._new(this.codeModel.ref(ArgumentException.class)).arg(JExpr.lit("invalid NULL argument to unary function")));
            }
            this.parent.assign(this.cycleCount, this.recycledArguments.get(0).length);
        } else {
            JConditional zeroLength = this.parent._if(this.anyZeroLength());
            zeroLength._then().assign(this.cycleCount, JExpr.lit(0));
            this.findLongestArgument(zeroLength._else());
        }
        if (this.overload.isDeferrable()) {
            DeferredVectorBuilder deferred = new DeferredVectorBuilder(this.codeModel, this.contextVar, this.primitive, this.overload);
            deferred.buildClass();
            deferred.maybeReturn(this.parent, this.cycleCount, this.deferredArgumentList(), this.copyAttributesFast());
        }
    }

    private void findLongestArgument(JBlock parent2) {
        parent2.assign(this.cycleCount, JExpr.lit(0));
        for (RecycledArgument arg : this.recycledArguments) {
            parent2._if(arg.length.gt(this.cycleCount))._then().assign(this.cycleCount, arg.length);
        }
    }

    private JExpression anyZeroLength() {
        Iterator<RecycledArgument> iterator = this.recycledArguments.iterator();
        JExpression expr = iterator.next().length.eq(JExpr.lit(0));
        while (iterator.hasNext()) {
            expr = expr.cor(iterator.next().length.eq(JExpr.lit(0)));
        }
        return expr;
    }

    private List<JExpression> deferredArgumentList() {
        for (JvmMethod.Argument arg : this.overload.getAllArguments()) {
            if (arg.isRecycle()) continue;
            throw new UnsupportedOperationException("All arguments of a deferred vector must be @Recycle");
        }
        ArrayList<JExpression> list2 = Lists.newArrayList();
        for (RecycledArgument arg : this.recycledArguments) {
            list2.add(arg.vector);
        }
        return list2;
    }

    private JExpression emptyResult() {
        return this.codeModel.ref(this.resultType.getVectorType()).staticRef("EMPTY");
    }

    private void initializeBuilder() {
        if (this.useArray) {
            JType arrayElementType = this.codeModel._ref(this.resultType.getBuilderArrayElementClass());
            JClass arrayClass = arrayElementType.array();
            this.builder = this.parent.decl(arrayElementType.array(), "array", JExpr.newArray(arrayElementType, this.cycleCount));
        } else {
            JClass builderClass = this.codeModel.ref(this.resultType.getBuilderClass());
            this.builder = this.parent.decl(builderClass, "builder", JExpr._new(builderClass).arg(this.cycleCount));
        }
    }

    private void loop() {
        JForLoop loop = this.parent._for();
        this.cycleIndex = loop.init(this.codeModel.INT, "i", JExpr.lit(0));
        loop.test(this.cycleIndex.ne(this.cycleCount));
        loop.update(this.cycleIndex.incr());
        this.calculateResult(loop.body());
        this.incrementCounters(loop.body());
    }

    private void calculateResult(JBlock loopBody) {
        if (!this.overload.isPassNA()) {
            JConditional ifNA = loopBody._if(this.isCurrentElementMissing());
            this.assignNA(ifNA._then());
            this.assignCycleResult(ifNA._else());
        } else {
            this.assignCycleResult(loopBody);
        }
    }

    private void incrementCounters(JBlock loopBody) {
        for (RecycledArgument arg : this.recycledArguments) {
            loopBody.assignPlus(arg.currentElementIndex, JExpr.lit(1));
            if (this.recycledArguments.size() <= 1) continue;
            loopBody._if(arg.currentElementIndex.eq(arg.length))._then().assign(arg.currentElementIndex, JExpr.lit(0));
        }
    }

    private JExpression isCurrentElementMissing() {
        if (this.recycledArguments.isEmpty()) {
            throw new IllegalStateException(this.overload.getName() + " is marked as @DataParallel, but has no parallel arguments");
        }
        JExpression condition = null;
        for (RecycledArgument arg : this.recycledArguments) {
            if (condition == null) {
                condition = arg.isCurrentElementNA();
                continue;
            }
            condition = condition.cor(arg.isCurrentElementNA());
        }
        return condition;
    }

    private void assignCycleResult(JBlock block) {
        if (this.useArray) {
            JArrayCompRef componentRef = this.builder.component(this.cycleIndex);
            block.assign(componentRef, this.computeCycleResult());
        } else {
            block.add(this.builder.invoke("set").arg(this.cycleIndex).arg(this.computeCycleResult()));
        }
    }

    private void assignNA(JBlock body2) {
        if (this.useArray) {
            body2.assign(this.builder.component(this.cycleIndex), this.resultType.naLiteral(this.codeModel));
        } else {
            body2.add(this.builder.invoke("setNA").arg(this.cycleIndex));
        }
    }

    private JExpression computeCycleResult() {
        JInvocation invocation = this.codeModel.ref(this.overload.getDeclaringClass()).staticInvoke(this.overload.getName());
        for (JvmMethod.Argument arg : this.overload.getAllArguments()) {
            if (!this.argumentMap.containsKey(arg)) {
                throw new AssertionError((Object)(arg.getName() + " not present in argumentMap"));
            }
            invocation.arg(this.argumentMap.get(arg));
        }
        if (this.useArray) {
            return this.resultType.toBuildArrayElementType(invocation);
        }
        return invocation;
    }

    private void copyAttributesUsingBuilder() {
        if (this.overload.getPreserveAttributesStyle() != PreserveAttributeStyle.NONE) {
            for (RecycledArgument arg : this.recycledArguments) {
                this.parent._if(arg.length.eq(this.cycleCount))._then().add(this.copyAttributesFrom(arg));
            }
        }
    }

    private JExpression copyAttributesFast() {
        if (this.overload.getPreserveAttributesStyle() == PreserveAttributeStyle.NONE) {
            return this.codeModel.ref(AttributeMap.class).staticRef("EMPTY");
        }
        if (this.recycledArguments.size() == 1) {
            return this.copyAttributes(this.recycledArguments.get(0).vector);
        }
        if (this.recycledArguments.size() == 2) {
            return this.copyAttributes(this.recycledArguments.get(0).vector, this.recycledArguments.get(1).vector);
        }
        throw new UnsupportedOperationException("arity = " + this.recycledArguments.size());
    }

    private JStatement copyAttributesFrom(RecycledArgument arg) {
        switch (this.overload.getPreserveAttributesStyle()) {
            case ALL: {
                return this.builder.invoke("combineAttributesFrom").arg(arg.vector);
            }
            case STRUCTURAL: {
                return this.builder.invoke("combineStructuralAttributesFrom").arg(arg.vector);
            }
        }
        throw new IllegalArgumentException("preserve attribute style: " + (Object)((Object)this.overload.getPreserveAttributesStyle()));
    }

    private JExpression copyAttributes(JExpression arg0, JExpression arg1) {
        String combineMethod;
        switch (this.overload.getPreserveAttributesStyle()) {
            case ALL: {
                combineMethod = "combineAttributes";
                break;
            }
            case STRUCTURAL: {
                combineMethod = "combineStructuralAttributes";
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return this.codeModel.ref(AttributeMap.class).staticInvoke(combineMethod).arg(arg0).arg(arg1);
    }

    private JExpression copyAttributes(JExpression arg) {
        if (this.overload.getPreserveAttributesStyle() == PreserveAttributeStyle.ALL) {
            return arg.invoke("getAttributes");
        }
        if (this.overload.getPreserveAttributesStyle() == PreserveAttributeStyle.STRUCTURAL) {
            return arg.invoke("getAttributes").invoke("copyStructural");
        }
        throw new UnsupportedOperationException();
    }

    private JExpression symbol(String name) {
        return this.codeModel.ref(Symbols.class).staticRef(name);
    }

    private JExpression buildResult() {
        if (this.useArray) {
            return JExpr._new(this.codeModel.ref(this.resultType.getArrayVectorClass())).arg(this.builder).arg(this.copyAttributesFast());
        }
        return this.builder.invoke("build");
    }

    private class RecycledArgument {
        private JvmMethod.Argument formal;
        private ScalarType scalarType;
        private JExpression sexp;
        private JVar vector;
        private JVar length;
        private JVar currentElementIndex;

        public RecycledArgument(JvmMethod.Argument argument, JExpression parameter) {
            this.formal = argument;
            this.scalarType = ScalarTypes.get(this.formal.getClazz());
            this.sexp = parameter;
            this.vector = RecycleLoopBuilder.this.parent.decl(RecycleLoopBuilder.this.codeModel.ref(Vector.class), "vector" + this.formal.getIndex(), JExpr.cast(RecycleLoopBuilder.this.codeModel.ref(Vector.class), this.sexp));
            this.length = RecycleLoopBuilder.this.parent.decl(RecycleLoopBuilder.this.codeModel._ref(Integer.TYPE), "length" + this.formal.getIndex(), this.vector.invoke("length"));
            this.currentElementIndex = RecycleLoopBuilder.this.parent.decl(RecycleLoopBuilder.this.codeModel._ref(Integer.TYPE), "currentElementIndex" + this.formal.getIndex(), JExpr.lit(0));
        }

        public JType getVectorType() {
            return RecycleLoopBuilder.this.codeModel.ref(this.scalarType.getVectorType());
        }

        public JExpression isCurrentElementNA() {
            if (RecycleLoopBuilder.this.overload.getReturnType().equals(Double.TYPE) || RecycleLoopBuilder.this.overload.getReturnType().equals(Complex.class)) {
                return this.vector.invoke("isElementNA").arg(this.currentElementIndex);
            }
            return this.vector.invoke("isElementNaN").arg(this.currentElementIndex);
        }

        public JExpression getCurrentElement() {
            return this.vector.invoke(this.scalarType.getAccessorMethod()).arg(this.currentElementIndex);
        }
    }
}

