/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.reflection.converters;

import org.renjin.invoke.reflection.converters.PrimitiveScalarConverter;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public class EnumConverter
extends PrimitiveScalarConverter<Enum> {
    private Class enumType;

    public EnumConverter(Class enumType) {
        this.enumType = enumType;
    }

    @Override
    public SEXP convertToR(Enum value) {
        return StringVector.valueOf(value.name());
    }

    @Override
    public Vector.Type getVectorType() {
        return StringVector.VECTOR_TYPE;
    }

    @Override
    protected Object getFirstElement(Vector value) {
        return Enum.valueOf(this.enumType, value.getElementAsString(0));
    }

    public static boolean accept(Class clazz) {
        return Enum.class.isAssignableFrom(clazz);
    }

    @Override
    public boolean acceptsSEXP(SEXP exp2) {
        return exp2 instanceof StringVector;
    }

    @Override
    public int getSpecificity() {
        return 300;
    }
}

