/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.bd0;
import org.renjin.nmath.dnorm;
import org.renjin.nmath.stirlerr;

public class dt {
    private dt() {
    }

    public static double dt(double d, double d2, int n) {
        double d3;
        double ax = 0.0;
        if (Builtins.__isnan(d) != 0 || Builtins.__isnan(d2) != 0) {
            d3 = d + d2;
        } else if (d2 <= 0.0) {
            d3 = 0.0 / 0.0;
        } else if (Builtins.__finite(d) == 0) {
            double iftmp$0 = n != 0 ? -1.0 / 0.0 : 0.0;
            d3 = iftmp$0;
        } else if (Builtins.__finite(d2) == 0) {
            d3 = dnorm.dnorm4(d, 0.0, 1.0, n);
        } else {
            double u;
            double l_x2n;
            boolean lrg_x2n;
            double d4 = stirlerr.Rf_stirlerr((d2 + 1.0) / 2.0);
            double d5 = (d2 + 1.0) / 2.0;
            double d6 = bd0.Rf_bd0(d2 / 2.0, d5);
            double d7 = d4 - d6;
            double d8 = stirlerr.Rf_stirlerr(d2 / 2.0);
            double t2 = d7 - d8;
            double d9 = d;
            double x2n = d9 * d9 / d2;
            boolean bl = lrg_x2n = x2n > 4.503599627370496E15;
            if (lrg_x2n) {
                ax = Math.abs(d);
                double d10 = Math.log(ax);
                double d11 = Math.log(d2) / 2.0;
                l_x2n = d10 - d11;
                u = d2 * l_x2n;
            } else if (x2n > 0.2) {
                l_x2n = Math.log(x2n + 1.0) / 2.0;
                u = d2 * l_x2n;
            } else {
                l_x2n = Mathlib.log1p(x2n) / 2.0;
                double d12 = d;
                double d13 = d12 * d12 / 2.0;
                double d14 = d;
                double d15 = (d14 * d14 + d2) / 2.0;
                double d16 = bd0.Rf_bd0(d2 / 2.0, d15);
                u = d13 - d16;
            }
            if (n != 0) {
                double d17 = t2 - u;
                double d18 = l_x2n + 0.9189385332046728;
                d3 = d17 - d18;
            } else {
                double iftmp$1 = lrg_x2n ? Mathlib.sqrt(d2) / ax : Math.exp(-l_x2n);
                double I_sqrt_ = iftmp$1;
                d3 = Math.exp(t2 - u) * 0.3989422804014327 * I_sqrt_;
            }
        }
        return d3;
    }
}

