/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.files;

import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import java.util.regex.Pattern;
import org.renjin.eval.Context;
import org.renjin.repackaged.guava.collect.Lists;

public class FileScanner {
    private List<String> matches = Lists.newArrayList();
    private String[] parts;
    private boolean markDirectories;

    public static List<String> scan(Context context, String path2, boolean markDirectories) {
        FileScanner scanner = new FileScanner(path2, markDirectories);
        scanner.matchRoots();
        return scanner.matches;
    }

    FileScanner(String path2, boolean markDirectories) {
        this.parts = path2.split("[\\\\//]");
        this.markDirectories = markDirectories;
    }

    private void matchRoots() {
        for (File root : File.listRoots()) {
            String rootName = root.getPath();
            if (!(rootName = rootName.substring(0, rootName.length() - 1)).equalsIgnoreCase(this.parts[0])) continue;
            this.match(root, 1);
        }
    }

    private void match(File dir2, int partIndex) {
        File[] matchingFiles = dir2.listFiles(new WildcardFilter(this.parts[partIndex]));
        if (matchingFiles != null) {
            for (File match2 : matchingFiles) {
                if (partIndex == this.parts.length - 1) {
                    if (match2.isDirectory() && this.markDirectories) {
                        this.matches.add(match2.getAbsolutePath() + File.separator);
                        continue;
                    }
                    this.matches.add(match2.getAbsolutePath());
                    continue;
                }
                if (!match2.isDirectory()) continue;
                this.match(match2, partIndex + 1);
            }
        }
    }

    private static String wildcardPattern(String pattern) {
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i != pattern.length(); ++i) {
            switch (pattern.charAt(i)) {
                case '.': {
                    sb.append("\\.");
                    continue block5;
                }
                case '?': {
                    sb.append(".?");
                    continue block5;
                }
                case '*': {
                    sb.append(".*");
                    continue block5;
                }
                default: {
                    sb.appendCodePoint(pattern.codePointAt(i));
                }
            }
        }
        return sb.toString();
    }

    private static class WildcardFilter
    implements FilenameFilter {
        private final boolean explicitDot;
        private final Pattern regex;

        private WildcardFilter(String wildcard) {
            this.regex = Pattern.compile(FileScanner.wildcardPattern(wildcard));
            this.explicitDot = wildcard.startsWith(".");
        }

        @Override
        public boolean accept(File dir2, String name) {
            if (name.startsWith(".") && !this.explicitDot) {
                return false;
            }
            return this.regex.matcher(name).matches();
        }
    }
}

