/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.primitives.subset.CoordinateMatrixIterator;
import org.renjin.primitives.subset.SelectionStrategy;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

class CoordinateMatrixSelection
implements SelectionStrategy {
    private final int numCoordinates;
    private AtomicVector matrix;
    private int[] matrixDims;

    public static boolean isCoordinateMatrix(SEXP source, SEXP subscript) {
        if (!(subscript instanceof IntVector) && !(subscript instanceof DoubleVector)) {
            return false;
        }
        Vector subscriptDim = subscript.getAttributes().getDim();
        if (subscriptDim.length() != 2) {
            return false;
        }
        SEXP sourceDim = source.getAttribute(Symbols.DIM);
        return sourceDim.length() == subscriptDim.getElementAsInt(1);
    }

    public CoordinateMatrixSelection(AtomicVector matrix2) {
        this.matrix = matrix2;
        this.matrixDims = matrix2.getAttributes().getDimArray();
        this.numCoordinates = this.matrixDims[0];
    }

    @Override
    public SEXP getVectorSubset(Context context, Vector source, boolean drop2) {
        int index;
        CoordinateMatrixIterator it = new CoordinateMatrixIterator(source, this.matrix);
        Vector.Builder result = source.getVectorType().newBuilderWithInitialCapacity(this.numCoordinates);
        int sourceLength = source.length();
        Vector materializedSource = context.materialize(source);
        while ((index = it.next()) != -1) {
            if (IntVector.isNA(index)) {
                result.addNA();
                continue;
            }
            if (index >= sourceLength) {
                throw new EvalException("subscript out of bounds", new Object[0]);
            }
            result.addFrom(materializedSource, index);
        }
        return result.build();
    }

    @Override
    public ListVector replaceListElements(Context context, ListVector source, Vector replacement) {
        return (ListVector)this.replaceElements(source, replacement);
    }

    @Override
    public Vector replaceAtomicVectorElements(Context context, AtomicVector source, Vector replacements) {
        return this.replaceElements(source, replacements);
    }

    private Vector replaceElements(Vector source, Vector replacements) {
        int index;
        CoordinateMatrixIterator it = new CoordinateMatrixIterator(source, this.matrix);
        Vector.Builder result = source.newCopyBuilder(replacements.getVectorType());
        int replacementIndex = 0;
        while ((index = it.next()) != -1) {
            if (IntVector.isNA(index)) {
                throw new EvalException("NAs are not allowed in subscripted assignments", new Object[0]);
            }
            if (index >= source.length()) {
                throw new EvalException("subscript out of bounds", new Object[0]);
            }
            if (replacements.length() == 0) {
                throw new EvalException("replacement has zero length", new Object[0]);
            }
            result.setFrom(index, replacements, replacementIndex++);
            if (replacementIndex < replacements.length()) continue;
            replacementIndex = 0;
        }
        if (replacementIndex != 0) {
            throw new EvalException("number of items to replace is not a multiple of replacement length", new Object[0]);
        }
        return result.build();
    }

    @Override
    public SEXP getSingleListElement(ListVector source, boolean exact) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AtomicVector getSingleAtomicVectorElement(AtomicVector source, boolean exact) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListVector replaceSingleListElement(ListVector list2, SEXP replacement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SEXP replaceSinglePairListElement(PairList.Node list2, SEXP replacement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Vector replaceSingleElement(AtomicVector source, Vector replacement) {
        throw new UnsupportedOperationException();
    }
}

