/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import org.renjin.eval.EvalException;
import org.renjin.primitives.subset.EmptyIndexIterator;
import org.renjin.primitives.subset.IndexIterator;
import org.renjin.primitives.subset.IndexPredicate;
import org.renjin.primitives.subset.LogicalPredicate;
import org.renjin.primitives.subset.Subscript;
import org.renjin.primitives.subset.SubsetAssertions;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.LogicalVector;

class LogicalSubscript
implements Subscript {
    private LogicalVector subscript;
    private int resultLength;

    public LogicalSubscript(LogicalVector subscript, int sourceLength) {
        this.subscript = subscript;
        this.resultLength = Math.max(sourceLength, subscript.length());
    }

    @Override
    public int computeUniqueIndex() {
        SubsetAssertions.checkUnitLength(this.subscript);
        int oneBasedIndex = this.subscript.getElementAsInt(0);
        if (IntVector.isNA(oneBasedIndex)) {
            throw new EvalException("subscript out of bounds", new Object[0]);
        }
        if (oneBasedIndex == 0) {
            throw new EvalException("attempt to select less than one element", new Object[0]);
        }
        return oneBasedIndex - 1;
    }

    @Override
    public IndexIterator computeIndexes() {
        if (this.subscript.length() == 0) {
            return EmptyIndexIterator.INSTANCE;
        }
        return new Iterator();
    }

    @Override
    public IndexPredicate computeIndexPredicate() {
        return new LogicalPredicate(this.subscript);
    }

    private class Iterator
    implements IndexIterator {
        int nextIndex = 0;

        private Iterator() {
        }

        @Override
        public int next() {
            int subscriptValue;
            do {
                int sourceIndex;
                if (this.nextIndex >= LogicalSubscript.this.resultLength) {
                    return -1;
                }
                ++this.nextIndex;
                subscriptValue = LogicalSubscript.this.subscript.getElementAsRawLogical(sourceIndex % LogicalSubscript.this.subscript.length());
                if (subscriptValue != 1) continue;
                return sourceIndex;
            } while (!IntVector.isNA(subscriptValue));
            return Integer.MIN_VALUE;
        }

        @Override
        public void restart() {
            this.nextIndex = 0;
        }
    }
}

