/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import java.util.List;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.primitives.Indexes;
import org.renjin.primitives.subset.ArrayIndexIterator;
import org.renjin.primitives.subset.IndexIterator;
import org.renjin.primitives.subset.IndexSubscript;
import org.renjin.primitives.subset.LogicalSubscript;
import org.renjin.primitives.subset.MissingSubscript;
import org.renjin.primitives.subset.NameSubscript;
import org.renjin.primitives.subset.SelectionStrategy;
import org.renjin.primitives.subset.Subscript;
import org.renjin.primitives.subset.SubsetAssertions;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

class MatrixSelection
implements SelectionStrategy {
    private List<SEXP> subscripts;

    public MatrixSelection(List<SEXP> subscripts) {
        this.subscripts = subscripts;
        assert (this.subscripts.size() > 1) : "matrix selection CAN ONLY applies with two or more arguments";
    }

    @Override
    public SEXP getVectorSubset(Context context, Vector source, boolean drop2) {
        int index;
        Subscript[] subscripts = this.parseSubscripts(source);
        int[] sourceDim = source.getAttributes().getDimArray();
        Vector materializedSource = context.materialize(source);
        ArrayIndexIterator it = new ArrayIndexIterator(sourceDim, subscripts);
        Vector.Builder result = source.getVectorType().newBuilder();
        while ((index = it.next()) != -1) {
            if (IntVector.isNA(index)) {
                result.addNA();
                continue;
            }
            if (index >= materializedSource.length()) {
                throw new EvalException("subscript out of bounds", new Object[0]);
            }
            result.addFrom(materializedSource, index);
        }
        int[] subscriptDim = this.computeSubscriptDim(subscripts);
        boolean[] droppedDim = this.dropRedundantDimensions(subscriptDim, drop2);
        Vector dimNames = this.computeDimNames(source, subscripts, droppedDim);
        int dimCount = this.countDims(droppedDim);
        if (drop2 && (dimCount == 0 || dimCount == 1)) {
            if (dimNames.length() > 0) {
                result.setAttribute(Symbols.NAMES, (SEXP)dimNames.getElementAsSEXP(0));
            }
        } else {
            result.setAttribute(Symbols.DIM, (SEXP)this.buildDimAttribute(subscriptDim, droppedDim));
            result.setAttribute(Symbols.DIMNAMES, (SEXP)dimNames);
        }
        return result.build();
    }

    @Override
    public SEXP getSingleListElement(ListVector source, boolean exact) {
        return this.getSingleElement(source);
    }

    @Override
    public AtomicVector getSingleAtomicVectorElement(AtomicVector source, boolean exact) {
        return (AtomicVector)this.getSingleElement(source);
    }

    private SEXP getSingleElement(Vector source) {
        int index = this.computeUniqueIndex(source);
        SubsetAssertions.checkBounds(source, index);
        return source.getElementAsSEXP(index);
    }

    private int countDims(boolean[] droppedDim) {
        int count = 0;
        for (int i = 0; i < droppedDim.length; ++i) {
            if (droppedDim[i]) continue;
            ++count;
        }
        return count;
    }

    private boolean[] dropRedundantDimensions(int[] subscriptDim, boolean drop2) {
        boolean[] dropped = new boolean[subscriptDim.length];
        if (drop2) {
            for (int i = 0; i < subscriptDim.length; ++i) {
                if (subscriptDim[i] != 1) continue;
                dropped[i] = true;
            }
        }
        return dropped;
    }

    private IntVector buildDimAttribute(int[] subscriptDim, boolean[] dropped) {
        IntArrayVector.Builder vector2 = new IntArrayVector.Builder(0, subscriptDim.length);
        for (int i = 0; i < subscriptDim.length; ++i) {
            if (dropped[i]) continue;
            vector2.add(subscriptDim[i]);
        }
        return vector2.build();
    }

    private int[] computeSubscriptDim(Subscript[] subscripts) {
        int[] dim2 = new int[subscripts.length];
        for (int i = 0; i < subscripts.length; ++i) {
            dim2[i] = this.computeCount(subscripts[i]);
        }
        return dim2;
    }

    private int computeCount(Subscript subscript) {
        IndexIterator it = subscript.computeIndexes();
        int count = 0;
        while (it.next() != -1) {
            ++count;
        }
        return count;
    }

    private Vector computeDimNames(Vector source, Subscript[] subscripts, boolean[] dropped) {
        Vector sourceDimNames = source.getAttributes().getDimNames();
        if (sourceDimNames == Null.INSTANCE) {
            return Null.INSTANCE;
        }
        ListVector.Builder newDimNames = ListVector.newBuilder();
        for (int d = 0; d < subscripts.length; ++d) {
            if (dropped[d]) continue;
            Object element = sourceDimNames.getElementAsSEXP(d);
            if (element instanceof StringVector && element.length() != 0) {
                int index;
                StringVector sourceNames = (StringVector)element;
                StringVector.Builder newNames = StringArrayVector.newBuilder();
                IndexIterator it = subscripts[d].computeIndexes();
                while ((index = it.next()) != -1) {
                    newNames.add(sourceNames.getElementAsString(index));
                }
                newDimNames.add(newNames.build());
                continue;
            }
            newDimNames.add(Null.INSTANCE);
        }
        return newDimNames.build();
    }

    @Override
    public ListVector replaceSingleListElement(ListVector source, SEXP replacement) {
        if (replacement == Null.INSTANCE) {
            throw new EvalException("incompatible types (from NULL to list) in [[ assignment", new Object[0]);
        }
        ListVector.NamedBuilder builder = source.newCopyNamedBuilder();
        int index = this.computeUniqueIndex(source);
        builder.set(index, replacement);
        return builder.build();
    }

    @Override
    public SEXP replaceSinglePairListElement(PairList.Node source, SEXP replacement) {
        PairList.Builder builder = source.newCopyBuilder();
        int index = this.computeUniqueIndex(source);
        builder.set(index, replacement);
        return builder.build();
    }

    @Override
    public Vector replaceSingleElement(AtomicVector source, Vector replacement) {
        if (replacement instanceof ListVector) {
            return this.replaceSingleAtomicVectorElementWithList(source, replacement);
        }
        int index = this.computeUniqueIndex(source);
        if (replacement.length() != 1) {
            throw new EvalException("more elements supplied than there are to replace", new Object[0]);
        }
        Vector.Builder builder = source.newCopyBuilder(replacement.getVectorType());
        builder.setFrom(index, replacement, 0);
        return builder.build();
    }

    private Vector replaceSingleAtomicVectorElementWithList(AtomicVector source, Vector replacement) {
        int indexToReplace = this.computeUniqueIndex(source);
        ListVector.Builder list2 = new ListVector.Builder();
        for (int i = 0; i < source.length(); ++i) {
            if (i == indexToReplace) {
                list2.add(replacement);
                continue;
            }
            list2.addFrom(source, i);
        }
        return list2.build();
    }

    @Override
    public ListVector replaceListElements(Context context, ListVector list2, Vector replacement) {
        return (ListVector)this.replaceVectorElements(context, list2, replacement);
    }

    @Override
    public Vector replaceAtomicVectorElements(Context context, AtomicVector source, Vector replacements) {
        return this.replaceVectorElements(context, source, replacements);
    }

    private Vector replaceVectorElements(Context context, Vector source, Vector replacements) {
        int index;
        Subscript[] subscripts = this.parseSubscripts(source);
        ArrayIndexIterator it = new ArrayIndexIterator(source.getAttributes().getDimArray(), subscripts);
        Vector.Builder result = source.newCopyBuilder(replacements.getVectorType());
        Vector materializedReplacement = context.materialize(replacements);
        int replacementIndex = 0;
        int replacementLength = replacements.length();
        while ((index = it.next()) != -1) {
            if (IntVector.isNA(index)) continue;
            if (index >= source.length()) {
                throw new EvalException("subscript out of bounds", new Object[0]);
            }
            result.setFrom(index, materializedReplacement, replacementIndex++);
            if (replacementIndex < replacementLength) continue;
            replacementIndex = 0;
        }
        if (replacementIndex != 0) {
            throw new EvalException("number of items to replace is not a multiple of replacement length", new Object[0]);
        }
        return result.build();
    }

    private Subscript[] parseSubscripts(SEXP source) {
        Subscript[] array2 = new Subscript[this.subscripts.size()];
        for (int i = 0; i < array2.length; ++i) {
            array2[i] = this.parseSubscript(source, this.subscripts.get(i), i);
        }
        return array2;
    }

    private Subscript parseSubscript(SEXP source, SEXP sexp2, int dimensionIndex) {
        int[] dim2 = source.getAttributes().getDimArray();
        if (dimensionIndex >= dim2.length) {
            throw new EvalException("incorrect number of dimensions", new Object[0]);
        }
        if (sexp2 == Symbol.MISSING_ARG) {
            return new MissingSubscript(dim2[dimensionIndex]);
        }
        if (sexp2 instanceof LogicalVector) {
            if (sexp2.length() > dim2[dimensionIndex]) {
                throw new EvalException("(subscript) logical subscript too long", new Object[0]);
            }
            return new LogicalSubscript((LogicalVector)sexp2, dim2[dimensionIndex]);
        }
        if (sexp2 instanceof StringVector) {
            Vector dimNamesList = source.getAttributes().getDimNames();
            if (dimNamesList == Null.INSTANCE) {
                throw new EvalException("no 'dimnames' attribute for array", new Object[0]);
            }
            return new NameSubscript((StringVector)sexp2, (AtomicVector)dimNamesList.getElementAsSEXP(dimensionIndex), false);
        }
        if (sexp2 instanceof DoubleVector || sexp2 instanceof IntVector) {
            return new IndexSubscript((AtomicVector)sexp2, dim2[dimensionIndex]);
        }
        if (sexp2 == Null.INSTANCE) {
            return new IndexSubscript(Null.INSTANCE, dim2[dimensionIndex]);
        }
        throw new EvalException("Invalid subscript type '%s'", sexp2.getTypeName());
    }

    private int computeUniqueIndex(SEXP source) {
        Subscript[] subscripts = this.parseSubscripts(source);
        int[] index = new int[subscripts.length];
        for (int i = 0; i != subscripts.length; ++i) {
            index[i] = subscripts[i].computeUniqueIndex();
        }
        return Indexes.arrayIndexToVectorIndex(index, source.getAttributes().getDimArray());
    }
}

