/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import java.util.HashMap;
import java.util.Map;
import org.renjin.eval.EvalException;
import org.renjin.primitives.subset.IndexIterator;
import org.renjin.primitives.subset.IndexPredicate;
import org.renjin.primitives.subset.Subscript;
import org.renjin.primitives.subset.SubsetAssertions;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.StringVector;

public class NameSubscript
implements Subscript {
    private StringVector selectedNames;
    private AtomicVector sourceNames;
    private boolean allowMissing;
    private Map<String, Integer> nameMap = null;

    public NameSubscript(StringVector selectedNames, AtomicVector sourceNames, boolean allowMissing) {
        this.selectedNames = selectedNames;
        this.sourceNames = sourceNames;
        this.allowMissing = allowMissing;
    }

    @Override
    public int computeUniqueIndex() {
        if (this.sourceNames == Null.INSTANCE) {
            throw new EvalException("attempt to select less than one element", new Object[0]);
        }
        SubsetAssertions.checkUnitLength(this.selectedNames);
        String selectedName = this.selectedNames.getElementAsString(0);
        for (int i = 0; i < this.selectedNames.length(); ++i) {
            String sourceName = this.sourceNames.getElementAsString(i);
            if (!(selectedName == null ? sourceName == null : selectedName.equals(sourceName))) continue;
            return i;
        }
        throw new EvalException("subscript out of bounds", new Object[0]);
    }

    @Override
    public IndexIterator computeIndexes() {
        this.buildMap();
        return new Iterator();
    }

    @Override
    public IndexPredicate computeIndexPredicate() {
        throw new UnsupportedOperationException();
    }

    private void buildMap() {
        if (this.nameMap == null) {
            this.nameMap = new HashMap<String, Integer>();
            for (int i = 0; i < this.sourceNames.length(); ++i) {
                String name = this.sourceNames.getElementAsString(i);
                if (this.nameMap.containsKey(name)) continue;
                this.nameMap.put(name, i);
            }
        }
    }

    private class Iterator
    implements IndexIterator {
        private int selectedNameIndex = 0;

        private Iterator() {
        }

        @Override
        public int next() {
            if (this.selectedNameIndex >= NameSubscript.this.selectedNames.length()) {
                return -1;
            }
            String selectedName = NameSubscript.this.selectedNames.getElementAsString(this.selectedNameIndex++);
            Integer index = (Integer)NameSubscript.this.nameMap.get(selectedName);
            if (index == null) {
                if (NameSubscript.this.allowMissing) {
                    return Integer.MIN_VALUE;
                }
                throw new EvalException("subscript '%s' out of bounds", selectedName);
            }
            return index;
        }

        @Override
        public void restart() {
            this.selectedNameIndex = 0;
        }
    }
}

