/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.repackaged.guava.collect;

import java.util.concurrent.ConcurrentMap;
import org.renjin.repackaged.guava.annotations.Beta;
import org.renjin.repackaged.guava.annotations.GwtIncompatible;
import org.renjin.repackaged.guava.base.Equivalence;
import org.renjin.repackaged.guava.base.Function;
import org.renjin.repackaged.guava.base.Preconditions;
import org.renjin.repackaged.guava.collect.Interner;
import org.renjin.repackaged.guava.collect.MapMaker;
import org.renjin.repackaged.guava.collect.MapMakerInternalMap;

@Beta
public final class Interners {
    private Interners() {
    }

    public static <E> Interner<E> newStrongInterner() {
        final ConcurrentMap map = new MapMaker().makeMap();
        return new Interner<E>(){

            @Override
            public E intern(E sample2) {
                Object canonical = map.putIfAbsent(Preconditions.checkNotNull(sample2), sample2);
                return canonical == null ? sample2 : canonical;
            }
        };
    }

    @GwtIncompatible(value="java.lang.ref.WeakReference")
    public static <E> Interner<E> newWeakInterner() {
        return new WeakInterner();
    }

    public static <E> Function<E, E> asFunction(Interner<E> interner) {
        return new InternerFunction<E>(Preconditions.checkNotNull(interner));
    }

    private static class InternerFunction<E>
    implements Function<E, E> {
        private final Interner<E> interner;

        public InternerFunction(Interner<E> interner) {
            this.interner = interner;
        }

        @Override
        public E apply(E input) {
            return this.interner.intern(input);
        }

        public int hashCode() {
            return this.interner.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof InternerFunction) {
                InternerFunction that = (InternerFunction)other;
                return this.interner.equals(that.interner);
            }
            return false;
        }
    }

    private static class WeakInterner<E>
    implements Interner<E> {
        private final MapMakerInternalMap<E, Dummy> map = ((MapMaker)new MapMaker().weakKeys().keyEquivalence((Equivalence)Equivalence.equals())).makeCustomMap();

        private WeakInterner() {
        }

        @Override
        public E intern(E sample2) {
            Dummy sneaky;
            do {
                E canonical;
                MapMakerInternalMap.ReferenceEntry<E, Dummy> entry;
                if ((entry = this.map.getEntry(sample2)) == null || (canonical = entry.getKey()) == null) continue;
                return canonical;
            } while ((sneaky = this.map.putIfAbsent(sample2, Dummy.VALUE)) != null);
            return sample2;
        }

        private static enum Dummy {
            VALUE;

        }
    }
}

