/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import org.renjin.eval.EvalException;
import org.renjin.primitives.vector.ConvertingStringVector;
import org.renjin.primitives.vector.RowNamesVector;
import org.renjin.repackaged.guava.base.Strings;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListBuilder;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class AttributeMap {
    private StringVector classes = null;
    private StringVector names = null;
    private IntVector dim = null;
    private ListVector dimNames = null;
    private Map<Symbol, SEXP> map;
    public static boolean CATCH_DEFINED = false;
    public static final AttributeMap EMPTY = new AttributeMap();

    public static void catchDefined() {
        CATCH_DEFINED = true;
    }

    private AttributeMap() {
    }

    public Vector getDim() {
        return (Vector)((Object)(this.dim == null ? Null.INSTANCE : this.dim));
    }

    public Iterable<Symbol> names() {
        ArrayList<Symbol> list2 = Lists.newArrayList();
        if (this.classes != null) {
            list2.add(Symbols.CLASS);
        }
        if (this.names != null) {
            list2.add(Symbols.NAMES);
        }
        if (this.dim != null) {
            list2.add(Symbols.DIM);
        }
        if (this.dimNames != null) {
            list2.add(Symbols.DIMNAMES);
        }
        if (this.map != null) {
            list2.addAll(this.map.keySet());
        }
        return list2;
    }

    public PairList asPairList() {
        PairList.Builder list2 = new PairList.Builder();
        this.addTo(list2);
        return list2.build();
    }

    public ListVector toVector() {
        ListVector.NamedBuilder list2 = new ListVector.NamedBuilder();
        this.addTo(list2);
        return list2.build();
    }

    private void addTo(ListBuilder list2) {
        if (this.classes != null) {
            list2.add(Symbols.CLASS, (SEXP)this.classes);
        }
        if (this.names != null) {
            list2.add(Symbols.NAMES, (SEXP)this.names);
        }
        if (this.dim != null) {
            list2.add(Symbols.DIM, (SEXP)this.dim);
        }
        if (this.dimNames != null) {
            list2.add(Symbols.DIMNAMES, (SEXP)this.dimNames);
        }
        if (this.map != null) {
            for (Map.Entry<Symbol, SEXP> entry : this.map.entrySet()) {
                list2.add(entry.getKey(), entry.getValue());
            }
        }
    }

    public SEXP get(String what) {
        return this.get(Symbol.get(what));
    }

    public boolean has(Symbol name) {
        return this.get(name) != Null.INSTANCE;
    }

    public SEXP get(Symbol name) {
        SEXP value;
        if (name == Symbols.CLASS) {
            return this.classes != null ? this.classes : Null.INSTANCE;
        }
        if (name == Symbols.DIM) {
            return this.dim != null ? this.dim : Null.INSTANCE;
        }
        if (name == Symbols.NAMES) {
            return this.names != null ? this.names : Null.INSTANCE;
        }
        if (name == Symbols.DIMNAMES) {
            return this.dimNames != null ? this.dimNames : Null.INSTANCE;
        }
        if (this.map != null && (value = this.map.get(name)) != null) {
            return value;
        }
        return Null.INSTANCE;
    }

    public Builder copy() {
        return new Builder(this);
    }

    public boolean hasAnyBesidesName() {
        return this.map != null || this.classes != null || this.dim != null || this.dimNames != null;
    }

    private boolean hasDim() {
        return this.dim != null;
    }

    public Iterable<PairList.Node> nodes() {
        return this.asPairList().nodes();
    }

    public int[] getDimArray() {
        if (this.dim == null) {
            return new int[0];
        }
        return this.dim.toIntArray();
    }

    public Vector getDimNames() {
        if (this.dimNames == null) {
            return Null.INSTANCE;
        }
        return this.dimNames;
    }

    public AtomicVector getDimNames(int i) {
        if (this.dimNames == null) {
            return Null.INSTANCE;
        }
        return (AtomicVector)this.dimNames.getElementAsSEXP(0);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean hasNames() {
        return this.names != null;
    }

    public StringVector getNames() {
        return this.names;
    }

    public boolean empty() {
        return this == EMPTY;
    }

    public boolean hasClass() {
        return this.classes != null;
    }

    public AtomicVector getClassVector() {
        return (AtomicVector)((Object)(this.classes == null ? Null.INSTANCE : this.classes));
    }

    public AtomicVector getNamesOrNull() {
        return (AtomicVector)((Object)(this.names == null ? Null.INSTANCE : this.names));
    }

    public AttributeMap copyNames() {
        if (this.names == null) {
            return EMPTY;
        }
        AttributeMap attributes2 = new AttributeMap();
        attributes2.names = this.names;
        return attributes2;
    }

    public AttributeMap copyStructural() {
        if (this.classes == null && this.map == null) {
            return this;
        }
        if (this.dim != null || this.names != null || this.map != null && this.map.containsKey(Symbols.DIMNAMES)) {
            SEXP dimnames2;
            AttributeMap copy2 = new AttributeMap();
            copy2.dim = this.dim;
            copy2.names = this.names;
            if (this.map != null && (dimnames2 = this.map.get(Symbols.DIMNAMES)) != null) {
                copy2.map = Maps.newIdentityHashMap();
                copy2.map.put(Symbols.DIMNAMES, dimnames2);
            }
            return copy2;
        }
        return EMPTY;
    }

    public static AttributeMap combineAttributes(Vector x, Vector y) {
        if (x.length() > y.length()) {
            return x.getAttributes();
        }
        if (y.length() > x.length()) {
            return y.getAttributes();
        }
        Builder builder = new Builder(x.getAttributes());
        builder.combineFrom(y.getAttributes());
        return builder.build();
    }

    public static AttributeMap combineStructuralAttributes(Vector x, Vector y) {
        if (x.length() > y.length()) {
            return x.getAttributes().copyStructural();
        }
        if (y.length() > x.length()) {
            return y.getAttributes().copyStructural();
        }
        Builder builder = new Builder();
        builder.combineStructuralFrom(x.getAttributes());
        builder.combineStructuralFrom(y.getAttributes());
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeMap that = (AttributeMap)o;
        if (this.classes != null ? !this.classes.equals(that.classes) : that.classes != null) {
            return false;
        }
        if (this.names != null ? !this.names.equals(that.names) : that.names != null) {
            return false;
        }
        if (this.dim != null ? !this.dim.equals(that.dim) : that.dim != null) {
            return false;
        }
        if (this.dimNames != null ? !this.dimNames.equals(that.dimNames) : that.dimNames != null) {
            return false;
        }
        return !(this.map == null ? that.map != null : !this.map.equals(that.map));
    }

    public int hashCode() {
        int result = this.classes != null ? this.classes.hashCode() : 0;
        result = 31 * result + (this.names != null ? this.names.hashCode() : 0);
        result = 31 * result + (this.dim != null ? this.dim.hashCode() : 0);
        result = 31 * result + (this.dimNames != null ? this.dimNames.hashCode() : 0);
        result = 31 * result + (this.map != null ? this.map.hashCode() : 0);
        return result;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static AttributeMap fromListVector(ListVector attributes2) {
        Builder builder = new Builder();
        for (int i = 0; i != attributes2.length(); ++i) {
            String attributeName = attributes2.getName(i);
            if (Strings.isNullOrEmpty(attributeName)) {
                throw new EvalException("Attributes must be named", new Object[0]);
            }
            SEXP attributeValue = attributes2.getElementAsSEXP(i);
            if (attributeValue == Null.INSTANCE) continue;
            builder.set(Symbol.get(attributeName), attributeValue);
        }
        return builder.build();
    }

    public static AttributeMap fromPairList(PairList list2) {
        if (list2 == Null.INSTANCE) {
            return EMPTY;
        }
        Builder attributes2 = new Builder();
        for (PairList.Node node : list2.nodes()) {
            attributes2.set(node.getTag(), node.getValue());
        }
        return attributes2.build();
    }

    public static AttributeMap dim(int row2, int col2) {
        AttributeMap map = new AttributeMap();
        map.dim = new IntArrayVector(row2, col2);
        return map;
    }

    public String getString(Symbol name) {
        SEXP value = this.get(name);
        if (value == Null.INSTANCE) {
            return null;
        }
        if (value instanceof StringVector) {
            if (value.length() == 1) {
                return ((StringVector)value).getElementAsString(0);
            }
            if (value.length() == 0) {
                return null;
            }
        }
        throw new EvalException("Expected character(1) value for attribute %s", name.getPrintName());
    }

    public String getPackage() {
        return this.getString(Symbols.PACKAGE);
    }

    public static class Builder {
        private StringVector classes = null;
        private StringVector names = null;
        private IntVector dim = null;
        private ListVector dimNames = null;
        private Map<Symbol, SEXP> map;
        private boolean empty = true;

        public Builder() {
        }

        private Builder(AttributeMap attributes2) {
            this.classes = attributes2.classes;
            this.names = attributes2.names;
            this.dim = attributes2.dim;
            this.dimNames = attributes2.dimNames;
            if (attributes2.map != null) {
                this.map = new IdentityHashMap<Symbol, SEXP>(attributes2.map);
            }
            this.updateEmptyFlag();
        }

        public Builder setDim(SEXP value) {
            if (value instanceof Null) {
                this.dim = null;
                this.updateEmptyFlag();
            } else {
                if (!(value instanceof Vector)) {
                    throw new EvalException("Invalid dim attribute of type '%s'", value.getTypeName());
                }
                if (value instanceof IntVector) {
                    this.dim = (IntVector)value;
                } else {
                    IntArrayVector.Builder dimVector = new IntArrayVector.Builder(0, value.length());
                    for (int i = 0; i < value.length(); ++i) {
                        dimVector.add(((AtomicVector)value).getElementAsInt(i));
                    }
                    this.dim = dimVector.build();
                }
                this.empty = false;
            }
            return this;
        }

        public Builder setDim(IntVector dim2) {
            assert (dim2 != null);
            this.dim = dim2;
            this.empty = false;
            return this;
        }

        public Builder setDim(int rows, int cols) {
            this.dim = new IntArrayVector(rows, cols);
            this.empty = false;
            return this;
        }

        public Builder setNames(StringVector names2) {
            assert (names2 != null);
            this.names = names2;
            this.empty = false;
            return this;
        }

        public Builder setNames(SEXP names2) {
            if (names2 == Null.INSTANCE) {
                this.remove(Symbols.NAMES);
            } else {
                if (!(names2 instanceof StringVector)) {
                    if (names2 instanceof Vector) {
                        names2 = new ConvertingStringVector((Vector)names2);
                    } else {
                        throw new EvalException("'names' vector must be a character", new Object[0]);
                    }
                }
                this.names = (StringVector)names2;
                this.empty = false;
            }
            return this;
        }

        public Builder setClass(String ... classNames) {
            this.classes = new StringArrayVector(classNames);
            this.empty = false;
            return this;
        }

        public Builder setClass(SEXP value) {
            if (value.length() == 0) {
                return this.remove(Symbols.CLASS);
            }
            this.classes = this.toNameVector(value);
            this.empty = false;
            return this;
        }

        public Builder setDimNames(SEXP value) {
            assert (value != null);
            if (value == Null.INSTANCE) {
                return this.remove(Symbols.DIMNAMES);
            }
            if (!(value instanceof ListVector)) {
                throw new EvalException("'dimnames' must be a list", new Object[0]);
            }
            this.dimNames = (ListVector)value;
            this.empty = false;
            return this;
        }

        public Builder setArrayNames(Vector names2) {
            if (names2 == Null.INSTANCE) {
                this.remove(Symbols.DIMNAMES);
            } else if (names2 instanceof StringVector) {
                this.setDimNames(new ListVector(names2));
            } else {
                throw new IllegalArgumentException("" + names2);
            }
            return this;
        }

        public Builder set(String name, SEXP value) {
            return this.set(Symbol.get(name), value);
        }

        public Builder set(Symbol name, SEXP value) {
            if (CATCH_DEFINED && name.getPrintName().equals("defined")) {
                throw new EvalException(value.toString(), new Object[0]);
            }
            if (value == Null.INSTANCE) {
                return this.remove(name);
            }
            if (name == Symbols.CLASS) {
                this.setClass(value);
            } else if (name == Symbols.NAMES) {
                this.setNames(value);
            } else if (name == Symbols.DIM) {
                this.setDim(value);
            } else if (name == Symbols.DIMNAMES) {
                this.setDimNames(value);
            } else {
                this.empty = false;
                if (this.map == null) {
                    this.map = Maps.newIdentityHashMap();
                }
                if (name == Symbols.ROW_NAMES) {
                    this.map.put(name, this.validateRowNames(value));
                } else {
                    this.map.put(name, value);
                }
            }
            return this;
        }

        private Vector validateRowNames(SEXP rowNames) {
            if (RowNamesVector.isOldCompactForm(rowNames)) {
                return RowNamesVector.fromOldCompactForm(rowNames);
            }
            if (rowNames instanceof Vector) {
                return (Vector)rowNames;
            }
            throw new EvalException("row names must be 'character' or 'integer', not '%s'", rowNames.getTypeName());
        }

        public Builder remove(Symbol name) {
            if (name == Symbols.CLASS) {
                this.classes = null;
            } else if (name == Symbols.NAMES) {
                this.names = null;
            } else if (name == Symbols.DIM) {
                this.dim = null;
            } else if (name == Symbols.DIMNAMES) {
                this.dimNames = null;
            } else if (this.map != null) {
                this.map.remove(name);
            }
            this.updateEmptyFlag();
            return this;
        }

        private void updateEmptyFlag() {
            this.empty = this.classes == null && this.dim == null && this.dimNames == null && this.names == null && (this.map == null || this.map.isEmpty());
        }

        public Builder removeDim() {
            this.dim = null;
            this.dimNames = null;
            this.updateEmptyFlag();
            return this;
        }

        public Builder removeDimnames() {
            this.dimNames = null;
            this.updateEmptyFlag();
            return this;
        }

        public SEXP get(String what) {
            return this.get(Symbol.get(what));
        }

        public SEXP get(Symbol name) {
            if (name == Symbols.CLASS) {
                return this.classes;
            }
            if (name == Symbols.NAMES) {
                return this.names;
            }
            if (name == Symbols.DIM) {
                return this.dim;
            }
            if (name == Symbols.DIMNAMES) {
                return this.dimNames;
            }
            if (this.map != null && this.map.containsKey(name)) {
                return this.map.get(name);
            }
            return Null.INSTANCE;
        }

        public Builder combineFrom(AttributeMap other) {
            return this.combineFrom(other, true);
        }

        public Builder combineStructuralFrom(AttributeMap other) {
            if (this.empty) {
                this.dim = other.dim;
                this.names = other.names;
                this.dimNames = other.dimNames;
                if (this.dim != null || this.names != null || this.dimNames != null) {
                    this.empty = false;
                }
            } else {
                this.combineFrom(other, false);
            }
            return this;
        }

        private Builder combineFrom(AttributeMap other, boolean all2) {
            if (other == EMPTY) {
                return this;
            }
            if (other.names != null && this.names == null && this.dim == null) {
                this.names = other.names;
            }
            if (other.dim != null) {
                if (this.dim == null) {
                    this.dim = other.dim;
                    this.names = null;
                } else if (!this.conforming(this.dim, other.dim)) {
                    throw new EvalException("non-conformable arrays", new Object[0]);
                }
                if (other.dimNames != null && this.dimNames == null) {
                    this.dimNames = other.dimNames;
                }
            }
            if (all2) {
                if (other.classes != null && this.classes == null) {
                    this.classes = other.classes;
                }
                if (other.map != null) {
                    if (this.map == null) {
                        this.map = new IdentityHashMap<Symbol, SEXP>(other.map);
                    } else {
                        for (Map.Entry entry : other.map.entrySet()) {
                            if (this.map.containsKey(entry.getKey())) continue;
                            this.map.put((Symbol)entry.getKey(), (SEXP)entry.getValue());
                        }
                    }
                }
            }
            this.updateEmptyFlag();
            return this;
        }

        private boolean conforming(IntVector dim1, IntVector dim2) {
            if (dim1.length() != dim2.length()) {
                return false;
            }
            for (int i = 0; i < dim1.length(); ++i) {
                if (dim1.getElementAsInt(i) == dim2.getElementAsInt(i)) continue;
                return false;
            }
            return true;
        }

        public Builder addAllFrom(AttributeMap attributes2) {
            if (attributes2.classes != null) {
                this.classes = attributes2.classes;
                this.empty = false;
            }
            if (attributes2.names != null) {
                this.names = attributes2.names;
                this.empty = false;
            }
            if (attributes2.dim != null) {
                this.dim = attributes2.dim;
                this.empty = false;
            }
            if (attributes2.dimNames != null) {
                this.dimNames = attributes2.dimNames;
                this.empty = false;
            }
            if (attributes2.map != null) {
                for (Map.Entry entry : attributes2.map.entrySet()) {
                    if (this.map == null) {
                        this.map = Maps.newIdentityHashMap();
                    }
                    this.map.put((Symbol)entry.getKey(), (SEXP)entry.getValue());
                    this.empty = false;
                }
            }
            return this;
        }

        public Builder addIfNotNull(AttributeMap source, Symbol symbol2) {
            SEXP value = source.get(symbol2);
            if (value != Null.INSTANCE) {
                this.set(symbol2, value);
            }
            return this;
        }

        public AttributeMap build() {
            if (this.empty) {
                return EMPTY;
            }
            assert (!this.reallyEmpty()) : "empty flag is wrong";
            AttributeMap attributes2 = new AttributeMap();
            attributes2.classes = this.classes;
            attributes2.dim = this.dim;
            attributes2.dimNames = this.validateDimNames();
            if (this.names != null) {
                attributes2.names = this.names;
            }
            if (this.map != null && !this.map.isEmpty()) {
                attributes2.map = this.map;
            }
            return attributes2;
        }

        private boolean reallyEmpty() {
            this.updateEmptyFlag();
            return this.empty;
        }

        public AttributeMap validateAndBuildFor(SEXP vector2) {
            return this.validateAndBuildForVectorOfLength(vector2.length());
        }

        public AttributeMap validateAndBuildForVectorOfLength(int length2) {
            if (this.empty) {
                return EMPTY;
            }
            assert (!this.reallyEmpty()) : "empty flag is wrong";
            AttributeMap attributes2 = new AttributeMap();
            attributes2.classes = this.classes;
            attributes2.dim = this.validateDim(length2);
            attributes2.dimNames = this.validateDimNames();
            attributes2.names = this.validateNames(length2);
            if (this.map != null && !this.map.isEmpty()) {
                attributes2.map = this.map;
            }
            return attributes2;
        }

        private IntVector validateDim(int vectorLength) {
            if (this.dim == null) {
                return null;
            }
            int prod2 = 1;
            for (int i = 0; i != this.dim.length(); ++i) {
                int dimLength = this.dim.getElementAsInt(i);
                if (dimLength < 0) {
                    throw new EvalException("the dims contain negative values", new Object[0]);
                }
                prod2 *= dimLength;
            }
            if (prod2 != vectorLength) {
                throw new EvalException("dims [product %d] do not match the length of object [%d]", prod2, vectorLength);
            }
            return this.dim;
        }

        private ListVector validateDimNames() {
            if (this.dimNames == null) {
                return null;
            }
            if (this.dimNames.length() == 0) {
                return null;
            }
            if (this.dim == null) {
                throw new EvalException("'dimnames' applied to non-array", new Object[0]);
            }
            if (this.dimNames.length() > this.dim.length()) {
                throw new EvalException("length of 'dimnames' [%d] must match that of 'dims' [%d]", this.dimNames.length(), this.dim.length());
            }
            ListVector.Builder builder = new ListVector.Builder();
            builder.setAttribute(Symbols.NAMES, (SEXP)this.dimNames.getNames());
            for (int i = 0; i < this.dim.length(); ++i) {
                if (i < this.dimNames.length()) {
                    builder.add(this.validateNames(i, this.dimNames.getElementAsSEXP(i)));
                    continue;
                }
                builder.add(Null.INSTANCE);
            }
            return builder.build();
        }

        private StringVector validateNames(int vectorLength) {
            if (this.names == null) {
                return null;
            }
            if (this.names.length() < vectorLength) {
                StringVector.Builder extendedNames = this.names.newCopyBuilder();
                while (extendedNames.length() < vectorLength) {
                    extendedNames.addNA();
                }
                return extendedNames.build();
            }
            if (this.names.length() > vectorLength) {
                throw new EvalException("'names' attribute [%d] must be the same length as the vector [%d]", this.names.length(), vectorLength);
            }
            return this.names;
        }

        private Vector validateNames(int dimIndex, SEXP names2) {
            if (!(names2 instanceof Vector)) {
                throw new EvalException("invalid type (%s) for 'dimnames' (must be a vector)", names2.getTypeName());
            }
            if (names2.length() == 0) {
                return Null.INSTANCE;
            }
            int dimLength = this.dim.getElementAsInt(dimIndex);
            if (names2.length() != dimLength) {
                throw new EvalException("for dimension [%d], length of 'dimnames' [%d] not equal to array extent [%d]", dimIndex, names2.length(), dimLength);
            }
            return this.toNameVector(names2);
        }

        private StringVector toNameVector(SEXP sexp2) {
            if (sexp2 instanceof StringVector) {
                return (StringVector)sexp2.setAttributes(EMPTY);
            }
            if (sexp2 instanceof Vector) {
                return StringArrayVector.fromVector((Vector)sexp2);
            }
            throw new EvalException("Cannot coerce '%s' to character", sexp2.getTypeName());
        }
    }
}

