/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.ArgumentList;
import org.renjin.invoke.annotations.Internal;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalBitSetVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class CompleteCases {
    @Internal(value="complete.cases")
    public static LogicalVector completeCases(@ArgumentList ListVector args2) {
        List<AtomicVector> vectors = CompleteCases.collectVectors(args2);
        int numCases = CompleteCases.countNumCases(vectors);
        BitSet bitSet = CompleteCases.allocBitVector(numCases);
        for (AtomicVector vector2 : vectors) {
            if (vector2 == Null.INSTANCE) continue;
            int caseIndex = 0;
            for (int i = 0; i != vector2.length(); ++i) {
                if (vector2.isElementNA(i)) {
                    bitSet.clear(caseIndex);
                }
                if (++caseIndex != numCases) continue;
                caseIndex = 0;
            }
        }
        return new LogicalBitSetVector(bitSet, numCases);
    }

    private static BitSet allocBitVector(int numCases) {
        BitSet bitSet = new BitSet(numCases);
        for (int caseIndex = 0; caseIndex != numCases; ++caseIndex) {
            bitSet.set(caseIndex);
        }
        return bitSet;
    }

    private static List<AtomicVector> collectVectors(ListVector args2) {
        ArrayList<AtomicVector> variables = Lists.newArrayList();
        for (SEXP arg : args2) {
            if (arg instanceof AtomicVector) {
                variables.add((AtomicVector)arg);
                continue;
            }
            if (arg instanceof ListVector) {
                for (SEXP vector2 : (ListVector)arg) {
                    if (vector2 instanceof AtomicVector) {
                        variables.add((AtomicVector)vector2);
                        continue;
                    }
                    throw new EvalException("invalid list member type: " + vector2.getTypeName(), new Object[0]);
                }
                continue;
            }
            throw new EvalException("invalid argument type: " + arg.getTypeName(), new Object[0]);
        }
        return variables;
    }

    private static int countNumCases(List<AtomicVector> variables) {
        int n = -1;
        for (AtomicVector arg : variables) {
            if (arg == Null.INSTANCE) continue;
            if (n == -1) {
                n = CompleteCases.numCases(arg);
                continue;
            }
            if (n == CompleteCases.numCases(arg)) continue;
            throw new EvalException("not all arguments have the same length", new Object[0]);
        }
        if (n == -1) {
            throw new EvalException("no input has determined the number of cases", new Object[0]);
        }
        return n;
    }

    private static int numCases(AtomicVector vector2) {
        Vector dim2 = vector2.getAttributes().getDim();
        if (dim2.length() == 2) {
            return dim2.getElementAsInt(0);
        }
        return vector2.length();
    }
}

