/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.models;

import java.util.ArrayList;
import java.util.List;
import org.renjin.eval.EvalException;
import org.renjin.primitives.matrix.Matrix;
import org.renjin.repackaged.guava.base.Joiner;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;
import org.renjin.stats.internals.models.InteractionMatrixColumn;
import org.renjin.stats.internals.models.ModelFrame;
import org.renjin.stats.internals.models.ModelMatrixColumn;
import org.renjin.stats.internals.models.Variable;

public class TermsObject {
    public static final Symbol INTERCEPT = Symbol.get("intercept");
    public static final Symbol RESPONSE = Symbol.get("response");
    public static final Symbol FACTORS = Symbol.get("factors");
    private final SEXP object;
    private final int intercept;
    private final int response;
    private final Matrix factorMatrix;
    private final StringVector variableNames;
    private final ModelFrame frame;
    private final List<Term> terms = Lists.newArrayList();

    public TermsObject(SEXP object2, ModelFrame frame2) {
        this.object = object2;
        this.frame = frame2;
        this.intercept = this.getIntAttribute(INTERCEPT);
        this.response = this.getIntAttribute(RESPONSE);
        try {
            this.factorMatrix = new Matrix((Vector)object2.getAttribute(FACTORS));
            this.variableNames = (StringVector)this.factorMatrix.getRowNames();
        }
        catch (Exception e) {
            throw new EvalException("invalid 'factors' attribute", new Object[0]);
        }
        for (int i = 0; i != this.getNumTerms(); ++i) {
            this.terms.add(new Term(i));
        }
    }

    public Iterable<Term> getTerms() {
        return this.terms;
    }

    private int getIntAttribute(Symbol attributeName) {
        SEXP exp2 = this.object.getAttribute(attributeName);
        if (!(exp2 instanceof AtomicVector) || exp2.length() != 1) {
            throw new EvalException("invalid attribute '" + attributeName + "'", new Object[0]);
        }
        return ((AtomicVector)exp2).getElementAsInt(0);
    }

    public int getIntercept() {
        return this.intercept;
    }

    public int getResponse() {
        return this.response;
    }

    public int getNumTerms() {
        return this.factorMatrix.getNumCols();
    }

    public int getNumVariables() {
        return this.factorMatrix.getNumRows();
    }

    public StringVector getVariableNames() {
        return this.variableNames;
    }

    public boolean hasIntercept() {
        return this.intercept == 1;
    }

    public Term getTerm(int index) {
        return this.terms.get(index);
    }

    public String toString() {
        return Joiner.on(" + ").join(this.terms);
    }

    public class Term {
        private int termIndex;
        private List<Variable> variables = Lists.newArrayList();

        public Term(int termIndex) {
            this.termIndex = termIndex;
            for (int i = 0; i != TermsObject.this.getNumVariables(); ++i) {
                if (!this.containsVariable(i)) continue;
                this.variables.add(TermsObject.this.frame.getVariable(i));
            }
        }

        public List<? extends ModelMatrixColumn> getModelMatrixColumns() {
            if (this.variables.size() == 1) {
                return this.variables.get(0).getModelMatrixColumns();
            }
            int numColumns = 1;
            for (Variable variable : this.variables) {
                List<? extends ModelMatrixColumn> columns = variable.getModelMatrixColumns();
                if (columns.size() <= numColumns) continue;
                numColumns = columns.size();
            }
            ArrayList<InteractionMatrixColumn> termColumns = Lists.newArrayList();
            for (int i = 0; i != numColumns; ++i) {
                ArrayList<ModelMatrixColumn> parts = Lists.newArrayList();
                for (Variable variable : this.variables) {
                    List<? extends ModelMatrixColumn> variableColumns = variable.getModelMatrixColumns();
                    parts.add(variableColumns.get(i % variableColumns.size()));
                }
                termColumns.add(new InteractionMatrixColumn(parts));
            }
            return termColumns;
        }

        public List<Variable> getVariables() {
            return this.variables;
        }

        public boolean containsVariable(int variableIndex) {
            return TermsObject.this.factorMatrix.getElementAsInt(variableIndex, this.termIndex) != 0;
        }

        public int getContrastType(int variableIndex) {
            return TermsObject.this.factorMatrix.getElementAsInt(variableIndex, this.termIndex);
        }

        public int getTermIndex() {
            return this.termIndex;
        }

        public boolean isResponse() {
            return TermsObject.this.response > 0 && this.containsVariable(TermsObject.this.response - 1) && this.size() == 1;
        }

        public int size() {
            int count = 0;
            for (int varIndex = 0; varIndex != TermsObject.this.getNumVariables(); ++varIndex) {
                if (!this.containsVariable(varIndex)) continue;
                ++count;
            }
            return count;
        }

        public Iterable<Integer> variableIndexes() {
            ArrayList<Integer> indices = Lists.newArrayList();
            for (int i = 0; i != TermsObject.this.getNumVariables(); ++i) {
                if (!this.containsVariable(i)) continue;
                indices.add(i);
            }
            return indices;
        }

        public String toString() {
            return Joiner.on(":").join(this.variables);
        }
    }
}

