/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.io.Serializable;
import org.apache.commons.math.linear.AbstractRealMatrix;
import org.apache.commons.math.linear.BlockRealMatrix;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.SparseRealMatrix;
import org.apache.commons.math.util.OpenIntToDoubleHashMap;

public class OpenMapRealMatrix
extends AbstractRealMatrix
implements SparseRealMatrix,
Serializable {
    private static final long serialVersionUID = -5962461716457143437L;
    private final int rows;
    private final int columns;
    private final OpenIntToDoubleHashMap entries;

    public OpenMapRealMatrix(int rowDimension, int columnDimension) {
        super(rowDimension, columnDimension);
        this.rows = rowDimension;
        this.columns = columnDimension;
        this.entries = new OpenIntToDoubleHashMap(0.0);
    }

    public OpenMapRealMatrix(OpenMapRealMatrix matrix2) {
        this.rows = matrix2.rows;
        this.columns = matrix2.columns;
        this.entries = new OpenIntToDoubleHashMap(matrix2.entries);
    }

    public OpenMapRealMatrix copy() {
        return new OpenMapRealMatrix(this);
    }

    public OpenMapRealMatrix createMatrix(int rowDimension, int columnDimension) throws IllegalArgumentException {
        return new OpenMapRealMatrix(rowDimension, columnDimension);
    }

    public int getColumnDimension() {
        return this.columns;
    }

    public OpenMapRealMatrix add(RealMatrix m) throws IllegalArgumentException {
        try {
            return this.add((OpenMapRealMatrix)m);
        }
        catch (ClassCastException cce) {
            return (OpenMapRealMatrix)super.add(m);
        }
    }

    public OpenMapRealMatrix add(OpenMapRealMatrix m) throws IllegalArgumentException {
        MatrixUtils.checkAdditionCompatible(this, m);
        OpenMapRealMatrix out = new OpenMapRealMatrix(this);
        OpenIntToDoubleHashMap.Iterator iterator = m.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            int row2 = iterator.key() / this.columns;
            int col2 = iterator.key() - row2 * this.columns;
            out.setEntry(row2, col2, this.getEntry(row2, col2) + iterator.value());
        }
        return out;
    }

    public OpenMapRealMatrix subtract(RealMatrix m) throws IllegalArgumentException {
        try {
            return this.subtract((OpenMapRealMatrix)m);
        }
        catch (ClassCastException cce) {
            return (OpenMapRealMatrix)super.subtract(m);
        }
    }

    public OpenMapRealMatrix subtract(OpenMapRealMatrix m) throws IllegalArgumentException {
        MatrixUtils.checkAdditionCompatible(this, m);
        OpenMapRealMatrix out = new OpenMapRealMatrix(this);
        OpenIntToDoubleHashMap.Iterator iterator = m.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            int row2 = iterator.key() / this.columns;
            int col2 = iterator.key() - row2 * this.columns;
            out.setEntry(row2, col2, this.getEntry(row2, col2) - iterator.value());
        }
        return out;
    }

    public RealMatrix multiply(RealMatrix m) throws IllegalArgumentException {
        try {
            return this.multiply((OpenMapRealMatrix)m);
        }
        catch (ClassCastException cce) {
            MatrixUtils.checkMultiplicationCompatible(this, m);
            int outCols = m.getColumnDimension();
            BlockRealMatrix out = new BlockRealMatrix(this.rows, outCols);
            OpenIntToDoubleHashMap.Iterator iterator = this.entries.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                double value = iterator.value();
                int key = iterator.key();
                int i = key / this.columns;
                int k = key % this.columns;
                for (int j = 0; j < outCols; ++j) {
                    out.addToEntry(i, j, value * m.getEntry(k, j));
                }
            }
            return out;
        }
    }

    public OpenMapRealMatrix multiply(OpenMapRealMatrix m) throws IllegalArgumentException {
        MatrixUtils.checkMultiplicationCompatible(this, m);
        int outCols = m.getColumnDimension();
        OpenMapRealMatrix out = new OpenMapRealMatrix(this.rows, outCols);
        OpenIntToDoubleHashMap.Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            double value = iterator.value();
            int key = iterator.key();
            int i = key / this.columns;
            int k = key % this.columns;
            for (int j = 0; j < outCols; ++j) {
                int rightKey = m.computeKey(k, j);
                if (!m.entries.containsKey(rightKey)) continue;
                int outKey = out.computeKey(i, j);
                double outValue = out.entries.get(outKey) + value * m.entries.get(rightKey);
                if (outValue == 0.0) {
                    out.entries.remove(outKey);
                    continue;
                }
                out.entries.put(outKey, outValue);
            }
        }
        return out;
    }

    public double getEntry(int row2, int column) throws MatrixIndexException {
        MatrixUtils.checkRowIndex(this, row2);
        MatrixUtils.checkColumnIndex(this, column);
        return this.entries.get(this.computeKey(row2, column));
    }

    public int getRowDimension() {
        return this.rows;
    }

    public void setEntry(int row2, int column, double value) throws MatrixIndexException {
        MatrixUtils.checkRowIndex(this, row2);
        MatrixUtils.checkColumnIndex(this, column);
        if (value == 0.0) {
            this.entries.remove(this.computeKey(row2, column));
        } else {
            this.entries.put(this.computeKey(row2, column), value);
        }
    }

    public void addToEntry(int row2, int column, double increment) throws MatrixIndexException {
        MatrixUtils.checkRowIndex(this, row2);
        MatrixUtils.checkColumnIndex(this, column);
        int key = this.computeKey(row2, column);
        double value = this.entries.get(key) + increment;
        if (value == 0.0) {
            this.entries.remove(key);
        } else {
            this.entries.put(key, value);
        }
    }

    public void multiplyEntry(int row2, int column, double factor) throws MatrixIndexException {
        MatrixUtils.checkRowIndex(this, row2);
        MatrixUtils.checkColumnIndex(this, column);
        int key = this.computeKey(row2, column);
        double value = this.entries.get(key) * factor;
        if (value == 0.0) {
            this.entries.remove(key);
        } else {
            this.entries.put(key, value);
        }
    }

    private int computeKey(int row2, int column) {
        return row2 * this.columns + column;
    }
}

