/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.provider.AbstractVfsComponent;
import org.apache.commons.vfs2.provider.FileReplicator;
import org.apache.commons.vfs2.provider.TemporaryFileStore;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.util.Messages;

public class DefaultFileReplicator
extends AbstractVfsComponent
implements FileReplicator,
TemporaryFileStore {
    private static final char[] TMP_RESERVED_CHARS = new char[]{'?', '/', '\\', ' ', '&', '\"', '\'', '*', '#', ';', ':', '<', '>', '|'};
    private static final Log log = LogFactory.getLog(DefaultFileReplicator.class);
    private static final int MASK = 65535;
    private final ArrayList<Object> copies = new ArrayList();
    private File tempDir;
    private long filecount;
    private boolean tempDirMessageLogged;

    public DefaultFileReplicator(File tempDir) {
        this.tempDir = tempDir;
    }

    public DefaultFileReplicator() {
    }

    public void init() throws FileSystemException {
        if (this.tempDir == null) {
            String baseTmpDir = System.getProperty("java.io.tmpdir");
            this.tempDir = new File(baseTmpDir, "vfs_cache").getAbsoluteFile();
        }
        this.filecount = new Random().nextInt() & 0xFFFF;
        if (!this.tempDirMessageLogged) {
            String message = Messages.getString("vfs.impl/temp-dir.info", this.tempDir);
            VfsLog.info(this.getLogger(), log, message);
            this.tempDirMessageLogged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList<Object> arrayList = this.copies;
        synchronized (arrayList) {
            while (this.copies.size() > 0) {
                File file2 = (File)this.removeFile();
                this.deleteFile(file2);
            }
        }
        if (this.tempDir != null && this.tempDir.exists() && this.tempDir.list().length == 0) {
            this.tempDir.delete();
            this.tempDir = null;
        }
    }

    protected void deleteFile(File file2) {
        try {
            FileObject fileObject = this.getContext().toFileObject(file2);
            fileObject.delete(Selectors.SELECT_ALL);
        }
        catch (FileSystemException e) {
            String message = Messages.getString("vfs.impl/delete-temp.warn", file2.getName());
            VfsLog.warn(this.getLogger(), log, message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object removeFile() {
        ArrayList<Object> arrayList = this.copies;
        synchronized (arrayList) {
            return this.copies.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFile(Object file2) {
        ArrayList<Object> arrayList = this.copies;
        synchronized (arrayList) {
            this.copies.remove(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File allocateFile(String baseName) throws FileSystemException {
        String basename2 = this.createFilename(baseName);
        DefaultFileReplicator defaultFileReplicator = this;
        synchronized (defaultFileReplicator) {
            ++this.filecount;
        }
        return this.createAndAddFile(this.tempDir, basename2);
    }

    protected File createAndAddFile(File parent2, String basename2) throws FileSystemException {
        File file2 = this.createFile(this.tempDir, basename2);
        this.addFile(file2);
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFile(Object file2) {
        ArrayList<Object> arrayList = this.copies;
        synchronized (arrayList) {
            this.copies.add(file2);
        }
    }

    protected long getFilecount() {
        return this.filecount;
    }

    protected String createFilename(String baseName) {
        String safeBasename = UriParser.encode(baseName, TMP_RESERVED_CHARS).replace('%', '_');
        return "tmp_" + this.getFilecount() + "_" + safeBasename;
    }

    protected File createFile(File parent2, String name) throws FileSystemException {
        return new File(parent2, UriParser.decode(name));
    }

    public File replicateFile(FileObject srcFile, FileSelector selector) throws FileSystemException {
        String basename2 = srcFile.getName().getBaseName();
        File file2 = this.allocateFile(basename2);
        FileObject destFile = this.getContext().toFileObject(file2);
        destFile.copyFrom(srcFile, selector);
        return file2;
    }
}

