/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.renjin.gcc.runtime.MallocThunk;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Realloc;

public class BytePtr
implements Ptr {
    public static final BytePtr NULL = new BytePtr();
    public final byte[] array;
    public final int offset;

    private BytePtr() {
        this.array = null;
        this.offset = 0;
    }

    public BytePtr(byte ... array2) {
        this(array2, 0);
    }

    public BytePtr(byte[] array2, int offset) {
        this.array = array2;
        this.offset = offset;
    }

    public byte get() {
        return this.array[this.offset];
    }

    public void set(byte value) {
        this.array[this.offset] = value;
    }

    public static byte[] toArray(String constant) {
        return constant.getBytes(StandardCharsets.UTF_8);
    }

    public static BytePtr asciiString(String string) {
        return new BytePtr(string.getBytes(StandardCharsets.US_ASCII), 0);
    }

    public static BytePtr nullTerminatedString(String string, Charset charset) {
        byte[] bytes = string.getBytes(charset);
        byte[] nullTerminatedBytes = Arrays.copyOf(bytes, bytes.length + 1);
        return new BytePtr(nullTerminatedBytes, 0);
    }

    public int nullTerminatedStringLength() {
        for (int i = this.offset; i < this.array.length; ++i) {
            if (this.array[i] != 0) continue;
            return i - this.offset;
        }
        throw new IllegalStateException("String is not null-terminated.");
    }

    public String nullTerminatedString() {
        return new String(this.array, this.offset, this.nullTerminatedStringLength(), StandardCharsets.UTF_8);
    }

    public String toString(int length2) {
        return new String(this.array, this.offset, length2, StandardCharsets.UTF_8);
    }

    public static void memset(byte[] str, int strOffset, int c2, int n) {
        Arrays.fill(str, strOffset, strOffset + c2 / 64, (byte)c2);
    }

    public static byte memset(int c2) {
        return (byte)c2;
    }

    public byte[] getArray() {
        return this.array;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public BytePtr realloc(int newSizeInBytes) {
        return new BytePtr(Realloc.realloc(this.array, this.offset, newSizeInBytes));
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        return new BytePtr(this.array, this.offset + 1);
    }

    public static BytePtr cast(Object voidPointer) {
        if (voidPointer instanceof MallocThunk) {
            return ((MallocThunk)voidPointer).bytePtr();
        }
        if (voidPointer == null) {
            return NULL;
        }
        return (BytePtr)voidPointer;
    }
}

