/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.bd0;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.stirlerr;

public class dbinom {
    private dbinom() {
    }

    public static double dbinom(double d, double d2, double d3, int n) {
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        if (Builtins.__isnan(d) != 0 || Builtins.__isnan(d2) != 0 || Builtins.__isnan(d3) != 0) {
            d8 = d + d2 + d3;
        } else if (d3 < 0.0 || d3 > 1.0 || d2 < 0.0 || (d7 = Math.abs(d2 - (d6 = Mathlib.round(d2)))) > (d5 = fmax2.fmax2(1.0, d4 = Math.abs(d2)) * 1.0E-7)) {
            d8 = 0.0 / 0.0;
        } else {
            double d9 = Mathlib.round(d);
            double d10 = Math.abs(d - d9);
            double d11 = Math.abs(d);
            double d12 = fmax2.fmax2(1.0, d11) * 1.0E-7;
            if (d10 > d12) {
                Stdlib.printf(new BytePtr("non-integer x = %f\u0000".getBytes(), 0), d);
                double iftmp$0 = n != 0 ? -1.0 / 0.0 : 0.0;
                d8 = iftmp$0;
            } else if (d < 0.0 || Builtins.__finite(d) == 0) {
                double iftmp$1 = n != 0 ? -1.0 / 0.0 : 0.0;
                d8 = iftmp$1;
            } else {
                d2 = Mathlib.round(d2);
                d = Mathlib.round(d);
                double d13 = 1.0 - d3;
                d8 = dbinom.dbinom_raw(d, d2, d3, d13, n);
            }
        }
        return d8;
    }

    public static double dbinom_raw(double d, double d2, double d3, double d4, int n) {
        double d5;
        if (d3 == 0.0) {
            double iftmp$2;
            if (d == 0.0) {
                double iftmp$3 = n != 0 ? 0.0 : 1.0;
                iftmp$2 = iftmp$3;
            } else {
                double iftmp$4 = n != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$2 = iftmp$4;
            }
            d5 = iftmp$2;
        } else if (d4 == 0.0) {
            double iftmp$5;
            if (d == d2) {
                double iftmp$6 = n != 0 ? 0.0 : 1.0;
                iftmp$5 = iftmp$6;
            } else {
                double iftmp$7 = n != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$5 = iftmp$7;
            }
            d5 = iftmp$5;
        } else if (d == 0.0) {
            if (d2 == 0.0) {
                double iftmp$8 = n != 0 ? 0.0 : 1.0;
                d5 = iftmp$8;
            } else {
                double iftmp$9;
                if (d3 < 0.1) {
                    double d6 = d2 * d4;
                    double d7 = -bd0.Rf_bd0(d2, d6);
                    double d8 = d2 * d3;
                    iftmp$9 = d7 - d8;
                } else {
                    iftmp$9 = Math.log(d4) * d2;
                }
                double lc = iftmp$9;
                double iftmp$10 = n == 0 ? Math.exp(lc) : lc;
                d5 = iftmp$10;
            }
        } else if (d == d2) {
            double iftmp$11;
            if (d4 < 0.1) {
                double d9 = d2 * d3;
                double d10 = -bd0.Rf_bd0(d2, d9);
                double d11 = d2 * d4;
                iftmp$11 = d10 - d11;
            } else {
                iftmp$11 = Math.log(d3) * d2;
            }
            double lc = iftmp$11;
            double iftmp$12 = n == 0 ? Math.exp(lc) : lc;
            d5 = iftmp$12;
        } else if (d < 0.0 || d > d2) {
            double iftmp$13 = n != 0 ? -1.0 / 0.0 : 0.0;
            d5 = iftmp$13;
        } else {
            double iftmp$14;
            double d12 = stirlerr.Rf_stirlerr(d2);
            double d13 = stirlerr.Rf_stirlerr(d);
            double d14 = d12 - d13;
            double d15 = stirlerr.Rf_stirlerr(d2 - d);
            double d16 = d14 - d15;
            double d17 = d2 * d3;
            double d18 = bd0.Rf_bd0(d, d17);
            double d19 = d16 - d18;
            double d20 = d2 * d4;
            double d21 = bd0.Rf_bd0(d2 - d, d20);
            double lc = d19 - d21;
            double d22 = Math.log(d) + 1.8378770664093456;
            double d23 = Mathlib.log1p(-d / d2);
            double lf = d22 + d23;
            if (n != 0) {
                double d24 = lf * 0.5;
                iftmp$14 = lc - d24;
            } else {
                double d25 = lf * 0.5;
                iftmp$14 = Math.exp(lc - d25);
            }
            d5 = iftmp$14;
        }
        return d5;
    }
}

