/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.lgamma;
import org.renjin.nmath.toms708;

public class pnbeta {
    public static double $Rf_pnbeta_raw$errmax = 1.0E-9;

    private pnbeta() {
    }

    public static double pnbeta(double d, double d2, double d3, double d4, int n, int n2) {
        double d5;
        if (Builtins.__isnan(d) != 0 || Builtins.__isnan(d2) != 0 || Builtins.__isnan(d3) != 0 || Builtins.__isnan(d4) != 0) {
            d5 = d + d2 + d3 + d4;
        } else if (d <= 0.0) {
            double iftmp$0;
            if (n != 0) {
                double iftmp$1 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$0 = iftmp$1;
            } else {
                double iftmp$2 = n2 != 0 ? 0.0 : 1.0;
                iftmp$0 = iftmp$2;
            }
            d5 = iftmp$0;
        } else if (d >= 1.0) {
            double iftmp$3;
            if (n != 0) {
                double iftmp$4 = n2 != 0 ? 0.0 : 1.0;
                iftmp$3 = iftmp$4;
            } else {
                double iftmp$5 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$3 = iftmp$5;
            }
            d5 = iftmp$3;
        } else {
            double d6 = 1.0 - d;
            d5 = pnbeta.Rf_pnbeta2(d, d6, d2, d3, d4, n, n2);
        }
        return d5;
    }

    public static double Rf_pnbeta2(double d, double d2, double d3, double d4, double d5, int n, int n2) {
        double d6;
        double ans = pnbeta.Rf_pnbeta_raw(d, d2, d3, d4, d5);
        if (n != 0) {
            double iftmp$6 = n2 != 0 ? Math.log(ans) : ans;
            d6 = iftmp$6;
        } else {
            if (ans > 0.9999999999) {
                byte[] msg = "\u0000".getBytes();
                int msg$offset = 0;
                msg = "full precision may not have been achieved in '%s'\n\u0000".getBytes();
                msg$offset = 0;
                Stdlib.printf(new BytePtr(msg, msg$offset), new BytePtr("pnbeta\u0000".getBytes(), 0));
            }
            if (ans > 1.0) {
                ans = 1.0;
            }
            double iftmp$7 = n2 != 0 ? Mathlib.log1p(-ans) : 1.0 - ans;
            d6 = iftmp$7;
        }
        return d6;
    }

    public static double Rf_pnbeta_raw(double d, double d2, double d3, double d4, double d5) {
        double d6;
        int[] ierr = new int[1];
        double[] tmp_c = new double[1];
        double[] temp = new double[1];
        ierr[0] = 0;
        tmp_c[0] = 0.0;
        temp[0] = 0.0;
        double x0 = 0.0;
        double c2 = 0.0;
        int itrmax = 0;
        itrmax = 10000;
        if (d5 < 0.0 || d3 <= 0.0 || d4 <= 0.0) {
            d6 = 0.0 / 0.0;
        } else if (d < 0.0 || d2 > 1.0 || d == 0.0 && d2 == 1.0) {
            d6 = 0.0;
        } else if (d > 1.0 || d2 < 0.0 || d == 1.0 && d2 == 0.0) {
            d6 = 1.0;
        } else {
            double errmax$14;
            double errbd;
            double ax;
            double q;
            c2 = d5 / 2.0;
            double d7 = Mathlib.sqrt(c2) * 7.0;
            x0 = Mathlib.floor(fmax2.fmax2(c2 - d7, 0.0));
            double a0 = d3 + x0;
            double d8 = lgamma.lgammafn(a0);
            double d9 = lgamma.lgammafn(d4);
            double d10 = d8 + d9;
            double d11 = lgamma.lgammafn(a0 + d4);
            double lbeta2 = d10 - d11;
            toms708.Rf_bratio(a0, d4, d, d2, new DoublePtr(temp, 0), new DoublePtr(tmp_c, 0), new IntPtr(ierr, 0), 0);
            double d12 = Math.log(d) * a0;
            double iftmp$8 = d < 0.5 ? Mathlib.log1p(-d) : Math.log(d2);
            double d13 = iftmp$8 * d4;
            double d14 = d12 + d13 - lbeta2;
            double d15 = Math.log(a0);
            double gx = Math.exp(d14 - d15);
            if (a0 > d3) {
                double d16 = Math.log(c2) * x0 - c2;
                double d17 = lgamma.lgammafn(x0 + 1.0);
                q = Math.exp(d16 - d17);
            } else {
                q = Math.exp(-c2);
            }
            double sumq = 1.0 - q;
            double temp$9 = temp[0];
            double ans = ax = q * temp$9;
            double j = Mathlib.floor(x0);
            do {
                double temp$11;
                temp[0] = temp$11 = temp[0] - gx;
                double d18 = (d3 + d4 + (j += 1.0) - 1.0) * d;
                double d19 = d3 + j;
                gx = d18 / d19 * gx;
                q = c2 / j * q;
                ax = temp[0] * q;
                ans += ax;
            } while ((errbd = (temp[0] - gx) * (sumq -= q)) > (errmax$14 = $Rf_pnbeta_raw$errmax) && (double)itrmax + x0 > j);
            double errmax$15 = $Rf_pnbeta_raw$errmax;
            if (errbd > errmax$15) {
                byte[] msg = "\u0000".getBytes();
                int msg$offset = 0;
                msg = "full precision may not have been achieved in '%s'\n\u0000".getBytes();
                msg$offset = 0;
                Stdlib.printf(new BytePtr(msg, msg$offset), new BytePtr("pnbeta\u0000".getBytes(), 0));
            }
            if ((double)itrmax + x0 <= j) {
                byte[] msg = "\u0000".getBytes();
                int msg$offset = 0;
                msg = "convergence failed in '%s'\n\u0000".getBytes();
                msg$offset = 0;
                Stdlib.printf(new BytePtr(msg, msg$offset), new BytePtr("pnbeta\u0000".getBytes(), 0));
            }
            d6 = ans;
        }
        return d6;
    }
}

