/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import java.util.Iterator;
import org.apache.commons.math.complex.Complex;
import org.renjin.eval.Profiler;
import org.renjin.repackaged.guava.collect.UnmodifiableIterator;
import org.renjin.sexp.AbstractVector;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.Logical;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public abstract class AbstractAtomicVector
extends AbstractVector
implements AtomicVector {
    protected AbstractAtomicVector(AttributeMap attributes2) {
        super(attributes2);
    }

    protected AbstractAtomicVector() {
    }

    @Override
    public boolean containsNA() {
        return this.indexOfNA() != -1;
    }

    @Override
    public boolean contains(Vector vector2, int vectorIndex) {
        if (vector2 instanceof AtomicVector) {
            return this.contains((AtomicVector)vector2, vectorIndex);
        }
        return false;
    }

    @Override
    public Complex getElementAsComplex(int index) {
        return new Complex(this.getElementAsDouble(index), 0.0);
    }

    @Override
    public int indexOfNA() {
        for (int i = 0; i != this.length(); ++i) {
            if (!this.isElementNA(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(AtomicVector vector2, int vectorIndex) {
        return this.indexOf(vector2, vectorIndex, 0) != -1;
    }

    @Override
    public int indexOf(Vector vector2, int vectorIndex, int startIndex) {
        if (vector2 instanceof AtomicVector) {
            return this.indexOf((AtomicVector)vector2, vectorIndex, startIndex);
        }
        Object element = vector2.getElementAsSEXP(vectorIndex);
        if (element instanceof AtomicVector && element.length() == 1) {
            return this.indexOf((AtomicVector)element, 0, startIndex);
        }
        return -1;
    }

    @Override
    public double[] toDoubleArray() {
        if (Profiler.ENABLED) {
            Profiler.memoryAllocated(64, this.length());
        }
        double[] d = new double[this.length()];
        for (int i = 0; i != d.length; ++i) {
            d[i] = this.getElementAsDouble(i);
        }
        return d;
    }

    @Override
    public int[] toIntArray() {
        if (Profiler.ENABLED) {
            Profiler.memoryAllocated(32, this.length());
        }
        int[] array2 = new int[this.length()];
        for (int i = 0; i != array2.length; ++i) {
            array2[i] = this.getElementAsInt(i);
        }
        return array2;
    }

    @Override
    public final boolean isWiderThan(Vector vector2) {
        return this.getVectorType().isWiderThan(vector2.getVectorType());
    }

    @Override
    public Logical getElementAsLogical(int index) {
        return Logical.valueOf(this.getElementAsRawLogical(index));
    }

    protected static abstract class AbstractAtomicBuilder
    extends AbstractVector.AbstractBuilder<Vector> {
        protected AbstractAtomicBuilder() {
        }

        @Override
        public Vector.Builder set(int destinationIndex, SEXP exp2) {
            if (!(exp2 instanceof AtomicVector) || exp2.length() != 1) {
                throw new IllegalArgumentException("the argument must be an atomic vector of length 1");
            }
            this.setFrom(destinationIndex, (AtomicVector)exp2, 0);
            return this;
        }

        @Override
        public Vector.Builder add(SEXP exp2) {
            if (!(exp2 instanceof AtomicVector) || exp2.length() != 1) {
                throw new IllegalArgumentException("the argument must be an atomic vector of length 1");
            }
            this.addFrom((AtomicVector)exp2, 0);
            return this;
        }
    }

    private class ElementIterator
    extends UnmodifiableIterator<SEXP> {
        private int index = 0;

        private ElementIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < AbstractAtomicVector.this.length();
        }

        @Override
        public SEXP next() {
            return AbstractAtomicVector.this.getElementAsSEXP(this.index++);
        }
    }

    private class Elements
    implements Iterable<SEXP> {
        private Elements() {
        }

        @Override
        public Iterator<SEXP> iterator() {
            return new ElementIterator();
        }
    }
}

