/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gnur.api.Error;
import org.renjin.gnur.api.GetText;
import org.renjin.gnur.api.Rinternals;
import org.renjin.sexp.SEXP;

public class family__ {
    public static double INVEPS = 4.503599627370496E15;
    public static double MTHRESH = -30.0;
    public static double THRESH = 30.0;

    private family__() {
    }

    public static SEXP binomial_dev_resids(SEXP sEXP, SEXP sEXP2, SEXP sEXP3) {
        double[] rans = null;
        int rans$offset = 0;
        double[] rwt = null;
        int rwt$offset = 0;
        double[] ry = null;
        int ry$offset = 0;
        double[] rmu = null;
        int rmu$offset = 0;
        double mui = 0.0;
        SEXP ans = null;
        int nprot = 0;
        int lwt = 0;
        int n = 0;
        n = Rinternals.LENGTH(sEXP);
        int lmu = Rinternals.LENGTH(sEXP2);
        lwt = Rinternals.LENGTH(sEXP3);
        nprot = 1;
        if (!Rinternals.Rf_isReal(sEXP)) {
            sEXP = Rinternals.Rf_protect(Rinternals.Rf_coerceVector(sEXP, 14));
            ++nprot;
        }
        DoublePtr doublePtr = Rinternals.REAL(sEXP);
        ry = doublePtr.array;
        ry$offset = doublePtr.offset;
        ans = Rinternals.Rf_protect(Rinternals.Rf_duplicate(sEXP));
        DoublePtr doublePtr2 = Rinternals.REAL(ans);
        rans = doublePtr2.array;
        rans$offset = doublePtr2.offset;
        if (!Rinternals.Rf_isReal(sEXP2)) {
            sEXP2 = Rinternals.Rf_protect(Rinternals.Rf_coerceVector(sEXP2, 14));
            ++nprot;
        }
        if (!Rinternals.Rf_isReal(sEXP3)) {
            sEXP3 = Rinternals.Rf_protect(Rinternals.Rf_coerceVector(sEXP3, 14));
            ++nprot;
        }
        DoublePtr doublePtr3 = Rinternals.REAL(sEXP2);
        rmu = doublePtr3.array;
        rmu$offset = doublePtr3.offset;
        DoublePtr doublePtr4 = Rinternals.REAL(sEXP3);
        rwt = doublePtr4.array;
        rwt$offset = doublePtr4.offset;
        if (lmu != n && lmu != 1) {
            BytePtr bytePtr = GetText.dgettext(new BytePtr("stats\u0000".getBytes(), 0), new BytePtr("argument %s must be a numeric vector of length 1 or length %d\u0000".getBytes(), 0));
            byte[] byArray = bytePtr.array;
            int n2 = bytePtr.offset;
            Error.Rf_error(new BytePtr(byArray, n2), new Object[0]);
        }
        if (lwt != n && lwt != 1) {
            BytePtr bytePtr = GetText.dgettext(new BytePtr("stats\u0000".getBytes(), 0), new BytePtr("argument %s must be a numeric vector of length 1 or length %d\u0000".getBytes(), 0));
            byte[] byArray = bytePtr.array;
            int n3 = bytePtr.offset;
            Error.Rf_error(new BytePtr(byArray, n3), new Object[0]);
        }
        if (lmu > 1) {
            int i = 0;
            while (i < n) {
                double d;
                int n4 = i * 8;
                double[] dArray = rmu;
                int n5 = rmu$offset + n4 / 8;
                mui = dArray[n5];
                int n6 = i * 8;
                double[] dArray2 = ry;
                int n7 = ry$offset + n6 / 8;
                double yi = dArray2[n7];
                int n8 = i * 8;
                double[] dArray3 = rans;
                int n9 = rans$offset + n8 / 8;
                int iftmp$3 = lwt > 1 ? i * 8 : 0;
                double[] dArray4 = rwt;
                int n10 = rwt$offset + iftmp$3 / 8;
                double d2 = dArray4[n10] * 2.0;
                double d3 = family__.y_log_y(yi, mui);
                double d4 = 1.0 - mui;
                double d5 = family__.y_log_y(1.0 - yi, d4);
                double d6 = d3 + d5;
                dArray3[n9] = d = d2 * d6;
                ++i;
            }
        } else {
            mui = rmu[rmu$offset];
            int i = 0;
            while (i < n) {
                double d;
                int n11 = i * 8;
                double[] dArray = ry;
                int n12 = ry$offset + n11 / 8;
                double yi = dArray[n12];
                int n13 = i * 8;
                double[] dArray5 = rans;
                int n14 = rans$offset + n13 / 8;
                int iftmp$7 = lwt > 1 ? i * 8 : 0;
                double[] dArray6 = rwt;
                int n15 = rwt$offset + iftmp$7 / 8;
                double d7 = dArray6[n15] * 2.0;
                double d8 = family__.y_log_y(yi, mui);
                double d9 = 1.0 - mui;
                double d10 = family__.y_log_y(1.0 - yi, d9);
                double d11 = d8 + d10;
                dArray5[n14] = d = d7 * d11;
                ++i;
            }
        }
        Rinternals.Rf_unprotect(nprot);
        return ans;
    }

    public static double y_log_y(double d, double d2) {
        double iftmp$9 = d != 0.0 ? Math.log(d / d2) * d : 0.0;
        return iftmp$9;
    }

    public static SEXP logit_mu_eta(SEXP sEXP) {
        double[] reta = null;
        int reta$offset = 0;
        double[] rans = null;
        int rans$offset = 0;
        int n = 0;
        SEXP ans = null;
        ans = Rinternals.Rf_protect(Rinternals.Rf_duplicate(sEXP));
        n = Rinternals.LENGTH(sEXP);
        DoublePtr doublePtr = Rinternals.REAL(ans);
        rans = doublePtr.array;
        rans$offset = doublePtr.offset;
        DoublePtr doublePtr2 = Rinternals.REAL(sEXP);
        reta = doublePtr2.array;
        reta$offset = doublePtr2.offset;
        if (n == 0 || !Rinternals.Rf_isReal(sEXP)) {
            BytePtr bytePtr = GetText.dgettext(new BytePtr("stats\u0000".getBytes(), 0), new BytePtr("Argument %s must be a nonempty numeric vector\u0000".getBytes(), 0));
            byte[] byArray = bytePtr.array;
            int n2 = bytePtr.offset;
            Error.Rf_error(new BytePtr(byArray, n2), new Object[0]);
        }
        int i = 0;
        while (i < n) {
            double iftmp$12;
            double MTHRESH$14;
            int n3 = i * 8;
            double[] dArray = reta;
            int n4 = reta$offset + n3 / 8;
            double etai = dArray[n4];
            double opexp = Math.exp(etai) + 1.0;
            int n5 = i * 8;
            double[] dArray2 = rans;
            int n6 = rans$offset + n5 / 8;
            double THRESH$13 = THRESH;
            if (etai > THRESH$13 ^ true && etai < (MTHRESH$14 = MTHRESH) ^ true) {
                double d = Math.exp(etai);
                double d2 = opexp;
                double d3 = d2 * d2;
                iftmp$12 = d / d3;
            } else {
                iftmp$12 = 2.220446049250313E-16;
            }
            dArray2[n6] = iftmp$12;
            ++i;
        }
        Rinternals.Rf_unprotect(1);
        return ans;
    }

    public static SEXP logit_linkinv(SEXP sEXP) {
        double[] reta = null;
        int reta$offset = 0;
        double[] rans = null;
        int rans$offset = 0;
        int n = 0;
        SEXP ans = null;
        ans = Rinternals.Rf_protect(Rinternals.Rf_duplicate(sEXP));
        n = Rinternals.LENGTH(sEXP);
        DoublePtr doublePtr = Rinternals.REAL(ans);
        rans = doublePtr.array;
        rans$offset = doublePtr.offset;
        DoublePtr doublePtr2 = Rinternals.REAL(sEXP);
        reta = doublePtr2.array;
        reta$offset = doublePtr2.offset;
        if (n == 0 || !Rinternals.Rf_isReal(sEXP)) {
            BytePtr bytePtr = GetText.dgettext(new BytePtr("stats\u0000".getBytes(), 0), new BytePtr("Argument %s must be a nonempty numeric vector\u0000".getBytes(), 0));
            byte[] byArray = bytePtr.array;
            int n2 = bytePtr.offset;
            Error.Rf_error(new BytePtr(byArray, n2), new Object[0]);
        }
        int i = 0;
        while (i < n) {
            double d;
            double iftmp$16;
            double[] dArray = reta;
            int n3 = i * 8;
            int n4 = reta$offset + n3 / 8;
            double etai = dArray[n4];
            double MTHRESH$17 = MTHRESH;
            if (etai < MTHRESH$17) {
                iftmp$16 = 2.220446049250313E-16;
            } else {
                double THRESH$19 = THRESH;
                double iftmp$18 = etai > THRESH$19 ? INVEPS : Math.exp(etai);
                iftmp$16 = iftmp$18;
            }
            double tmp = iftmp$16;
            int n5 = i * 8;
            double[] dArray2 = rans;
            int n6 = rans$offset + n5 / 8;
            dArray2[n6] = d = family__.x_d_opx(tmp);
            ++i;
        }
        Rinternals.Rf_unprotect(1);
        return ans;
    }

    public static double x_d_opx(double d) {
        double d2 = d + 1.0;
        return d / d2;
    }

    public static SEXP logit_link(SEXP sEXP) {
        double[] rmu = null;
        int rmu$offset = 0;
        double[] rans = null;
        int rans$offset = 0;
        SEXP ans = null;
        int n = 0;
        n = Rinternals.LENGTH(sEXP);
        ans = Rinternals.Rf_protect(Rinternals.Rf_duplicate(sEXP));
        DoublePtr doublePtr = Rinternals.REAL(ans);
        rans = doublePtr.array;
        rans$offset = doublePtr.offset;
        DoublePtr doublePtr2 = Rinternals.REAL(sEXP);
        rmu = doublePtr2.array;
        rmu$offset = doublePtr2.offset;
        if (n == 0 || !Rinternals.Rf_isReal(sEXP)) {
            BytePtr bytePtr = GetText.dgettext(new BytePtr("stats\u0000".getBytes(), 0), new BytePtr("Argument %s must be a nonempty numeric vector\u0000".getBytes(), 0));
            byte[] byArray = bytePtr.array;
            int n2 = bytePtr.offset;
            Error.Rf_error(new BytePtr(byArray, n2), new Object[0]);
        }
        int i = 0;
        while (i < n) {
            double d;
            int n3 = i * 8;
            double[] dArray = rans;
            int n4 = rans$offset + n3 / 8;
            int n5 = i * 8;
            double[] dArray2 = rmu;
            int n6 = rmu$offset + n5 / 8;
            dArray[n4] = d = Math.log(family__.x_d_omx(dArray2[n6]));
            ++i;
        }
        Rinternals.Rf_unprotect(1);
        return ans;
    }

    public static double x_d_omx(double d) {
        if (d < 0.0 || d > 1.0) {
            BytePtr bytePtr = GetText.dgettext(new BytePtr("stats\u0000".getBytes(), 0), new BytePtr("Value %g out of range (0, 1)\u0000".getBytes(), 0));
            byte[] byArray = bytePtr.array;
            int n = bytePtr.offset;
            Error.Rf_error(new BytePtr(byArray, n), new Object[0]);
        }
        double d2 = 1.0 - d;
        return d / d2;
    }
}

