/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.util;

import java.io.File;
import java.io.PrintWriter;

public class DebugGraph {
    private final PrintWriter writer;
    private File tempFile;

    public DebugGraph(String compute) {
        try {
            this.tempFile = File.createTempFile("deferred", ".dot");
            this.writer = new PrintWriter(this.tempFile);
            this.writer.println("digraph G { ");
            System.out.println("Dumping " + compute + " graph to " + this.tempFile.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public DebugGraph() {
        this("compute");
    }

    public void printEdge(String fromId, String toId) {
        this.writer.println(fromId + " -> " + toId);
    }

    public void printNode(String nodeId, String label) {
        this.writer.println(nodeId + " [ label=\"" + label + "\"]");
    }

    public void close() {
        try {
            this.writer.println("}");
            this.writer.close();
            File tempPng = File.createTempFile("graph", ".png");
            try {
                Runtime.getRuntime().exec(new String[]{"dot", "-T", "png", "-o", tempPng.getAbsolutePath(), this.tempFile.getAbsolutePath()});
                System.out.println("Graph drawn to " + tempPng);
            }
            catch (Exception e) {
                System.out.println("Failed to render graph: " + e.getMessage());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

