/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.builtins;

import java.util.List;
import org.renjin.compiler.builtins.ArgumentBounds;
import org.renjin.compiler.builtins.BuiltinSpecializer;
import org.renjin.compiler.builtins.ConstantCall;
import org.renjin.compiler.builtins.Specialization;
import org.renjin.compiler.builtins.StaticMethodCall;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.exception.InvalidSyntaxException;
import org.renjin.compiler.ir.tac.RuntimeState;
import org.renjin.invoke.model.JvmMethod;
import org.renjin.primitives.Attributes;
import org.renjin.repackaged.guava.collect.Iterables;

public class DimSpecializer
implements BuiltinSpecializer {
    private JvmMethod method = Iterables.getOnlyElement(JvmMethod.findOverloads(Attributes.class, "dim", null));

    @Override
    public String getName() {
        return "dim";
    }

    @Override
    public String getGroup() {
        return null;
    }

    @Override
    public Specialization trySpecialize(RuntimeState runtimeState, List<ArgumentBounds> arguments) {
        if (arguments.size() != 1) {
            throw new InvalidSyntaxException("dim() takes one argument.");
        }
        ValueBounds sexp2 = arguments.get(0).getBounds();
        if (sexp2.isDimAttributeConstant()) {
            return new ConstantCall(sexp2.getConstantDimAttribute());
        }
        return new StaticMethodCall(this.method);
    }
}

