/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.builtins;

import java.util.List;
import org.renjin.compiler.builtins.ArgumentBounds;
import org.renjin.compiler.builtins.BuiltinSpecializer;
import org.renjin.compiler.builtins.S3Specialization;
import org.renjin.compiler.builtins.S4Specialization;
import org.renjin.compiler.builtins.Specialization;
import org.renjin.compiler.builtins.Specializer;
import org.renjin.compiler.builtins.UnspecializedCall;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.RuntimeState;
import org.renjin.sexp.Null;

public class GenericBuiltinGuard
implements Specializer {
    private final BuiltinSpecializer specializer;

    public GenericBuiltinGuard(BuiltinSpecializer specializer) {
        this.specializer = specializer;
    }

    @Override
    public Specialization trySpecialize(RuntimeState runtimeState, List<ArgumentBounds> arguments) {
        ValueBounds object2 = arguments.get(0).getBounds();
        if (object2.isClassAttributeConstant()) {
            if (object2.getTypeSet() == 8192) {
                return S4Specialization.trySpecialize(this.specializer.getName(), runtimeState, object2, arguments);
            }
            if (object2.getConstantClassAttribute() != Null.INSTANCE) {
                return S3Specialization.trySpecialize(this.specializer.getName(), runtimeState, object2, arguments);
            }
            return this.specializer.trySpecialize(runtimeState, arguments);
        }
        return UnspecializedCall.INSTANCE;
    }
}

