/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.builtins;

import java.util.List;
import org.renjin.compiler.builtins.ArgumentBounds;
import org.renjin.compiler.builtins.BuiltinSpecializer;
import org.renjin.compiler.builtins.ConstantCall;
import org.renjin.compiler.builtins.Specialization;
import org.renjin.compiler.builtins.StaticMethodCall;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.exception.InvalidSyntaxException;
import org.renjin.compiler.ir.tac.RuntimeState;
import org.renjin.invoke.model.JvmMethod;
import org.renjin.primitives.Types;
import org.renjin.repackaged.guava.collect.Iterables;

public class IsArraySpecializer
implements BuiltinSpecializer {
    private JvmMethod method = Iterables.getOnlyElement(JvmMethod.findOverloads(Types.class, "is.array", null));

    @Override
    public String getName() {
        return "is.array";
    }

    @Override
    public String getGroup() {
        return null;
    }

    @Override
    public Specialization trySpecialize(RuntimeState runtimeState, List<ArgumentBounds> arguments) {
        if (arguments.size() != 1) {
            throw new InvalidSyntaxException("is.array() takes one argument.");
        }
        ValueBounds argumentBounds = arguments.get(0).getBounds();
        if (argumentBounds.isDimCountConstant()) {
            return new ConstantCall(argumentBounds.getConstantDimCount() > 0);
        }
        return new StaticMethodCall(this.method);
    }
}

