/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.builtins;

import java.util.List;
import org.renjin.compiler.builtins.ArgumentBounds;
import org.renjin.compiler.builtins.BuiltinSpecializer;
import org.renjin.compiler.builtins.ConstantCall;
import org.renjin.compiler.builtins.LengthCall;
import org.renjin.compiler.builtins.Specialization;
import org.renjin.compiler.builtins.Specializer;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.exception.InvalidSyntaxException;
import org.renjin.compiler.ir.tac.RuntimeState;

public class LengthSpecializer
implements Specializer,
BuiltinSpecializer {
    @Override
    public String getName() {
        return "length";
    }

    @Override
    public String getGroup() {
        return null;
    }

    @Override
    public Specialization trySpecialize(RuntimeState runtimeState, List<ArgumentBounds> arguments) {
        if (arguments.size() != 1) {
            throw new InvalidSyntaxException("length() takes one argument.");
        }
        ValueBounds argumentBounds = arguments.get(0).getBounds();
        if (argumentBounds.isLengthConstant()) {
            return new ConstantCall(argumentBounds.getLength());
        }
        return new LengthCall();
    }
}

