/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.cfg;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.renjin.compiler.TypeSolver;
import org.renjin.compiler.builtins.ArgumentBounds;
import org.renjin.compiler.cfg.ControlFlowGraph;
import org.renjin.compiler.cfg.DominanceTree;
import org.renjin.compiler.cfg.UseDefMap;
import org.renjin.compiler.codegen.ByteCodeEmitter;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.codegen.InlineEmitContext;
import org.renjin.compiler.codegen.InlineParamExpr;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.ssa.SsaTransformer;
import org.renjin.compiler.ir.tac.IRArgument;
import org.renjin.compiler.ir.tac.IRBody;
import org.renjin.compiler.ir.tac.IRBodyBuilder;
import org.renjin.compiler.ir.tac.RuntimeState;
import org.renjin.compiler.ir.tac.expressions.ReadParam;
import org.renjin.compiler.ir.tac.statements.ReturnStatement;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.eval.MatchedArgumentPositions;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Function;
import org.renjin.sexp.Symbol;

public class InlinedFunction {
    private final RuntimeState runtimeState;
    private final SsaTransformer ssaTransformer;
    private final DominanceTree dTree;
    private final ControlFlowGraph cfg;
    private final UseDefMap useDefMap;
    private final TypeSolver types;
    private final List<ReadParam> params;
    private List<ReturnStatement> returnStatements = Lists.newArrayList();
    private Closure closure;

    public InlinedFunction(RuntimeState parentState, Closure closure, Set<Symbol> arguments) {
        this.closure = closure;
        this.runtimeState = new RuntimeState(parentState, closure.getEnclosingEnvironment());
        IRBodyBuilder builder = new IRBodyBuilder(this.runtimeState);
        IRBody body2 = builder.buildFunctionBody(closure, arguments);
        this.cfg = new ControlFlowGraph(body2);
        this.dTree = new DominanceTree(this.cfg);
        this.ssaTransformer = new SsaTransformer(this.cfg, this.dTree);
        this.ssaTransformer.transform();
        this.useDefMap = new UseDefMap(this.cfg);
        this.types = new TypeSolver(this.cfg, this.useDefMap);
        this.params = body2.getParams();
        for (Statement statement : body2.getStatements()) {
            if (!(statement instanceof ReturnStatement)) continue;
            this.returnStatements.add((ReturnStatement)statement);
        }
    }

    public ControlFlowGraph getCfg() {
        return this.cfg;
    }

    public SsaTransformer getSsaTransformer() {
        return this.ssaTransformer;
    }

    public List<ReadParam> getParams() {
        return this.params;
    }

    public void updateParam(int i, ValueBounds argumentBounds) {
        this.params.get(i).updateBounds(argumentBounds);
    }

    public ValueBounds updateBounds(List<ArgumentBounds> arguments) {
        for (int i = 0; i < arguments.size(); ++i) {
            this.updateParam(i, arguments.get(i).getBounds());
        }
        return this.computeBounds();
    }

    public ValueBounds computeBounds() {
        this.types.execute();
        ArrayList<ValueBounds> returnBounds = new ArrayList<ValueBounds>();
        for (ReturnStatement returnStatement : this.returnStatements) {
            returnBounds.add(returnStatement.getRHS().getValueBounds());
        }
        return ValueBounds.union(returnBounds);
    }

    public boolean isPure() {
        return this.types.isPure();
    }

    public void writeInline(EmitContext emitContext, InstructionAdapter mv, MatchedArgumentPositions matching, List<IRArgument> arguments) {
        InlineEmitContext inlineContext = emitContext.inlineContext(this.cfg, this.types);
        for (Map.Entry<Symbol, Integer> formal : matching.getMatchedFormals().entrySet()) {
            inlineContext.setInlineParameter(formal.getKey(), new InlineParamExpr(emitContext, arguments.get(formal.getValue()).getExpression()));
        }
        this.types.verifyFunctionAssumptions(this.runtimeState);
        ByteCodeEmitter.writeBody(inlineContext, mv, this.cfg);
    }

    public void write(EmitContext emitContext, InstructionAdapter mv) {
        this.types.verifyFunctionAssumptions(this.runtimeState);
        ByteCodeEmitter.writeBody(emitContext, mv, this.cfg);
    }

    public String toString() {
        return this.cfg.toString();
    }

    public TypeSolver getTypes() {
        return this.types;
    }

    public Function getClosure() {
        return this.closure;
    }
}

