/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.codegen;

import java.io.PrintWriter;
import org.renjin.compiler.CompiledLoopBody;
import org.renjin.compiler.JitClassLoader;
import org.renjin.compiler.cfg.InlinedFunction;
import org.renjin.compiler.codegen.ApplyMethodContext;
import org.renjin.compiler.codegen.VariableSlots;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.primitives.vector.MemoizedComputation;
import org.renjin.repackaged.asm.ClassVisitor;
import org.renjin.repackaged.asm.ClassWriter;
import org.renjin.repackaged.asm.MethodVisitor;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.repackaged.asm.util.TraceClassVisitor;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;

public class ApplyCallWriter {
    private static final Type ATTRIBUTE_MAP_TYPE = Type.getType(AttributeMap.class);
    private static final Type VECTOR_TYPE = Type.getType(Vector.class);
    private ClassWriter cw;
    private ClassVisitor cv;
    private Type thisClass;
    private Type superClass;
    private InlinedFunction function;
    private Symbol elementFormalName;
    private ValueBounds elementBounds;
    private ValueBounds resultBounds;
    private final int uniqueId;

    public ApplyCallWriter(InlinedFunction function2, Symbol elementFormalName, ValueBounds elementBounds, ValueBounds resultBounds) {
        this.function = function2;
        this.elementFormalName = elementFormalName;
        this.elementBounds = elementBounds;
        this.resultBounds = resultBounds;
        this.uniqueId = System.identityHashCode(this);
        this.thisClass = Type.getType("org/renjin/DeferredApply" + this.uniqueId);
        this.superClass = Type.getType(DoubleVector.class);
    }

    public Class<?> build() {
        this.startClass();
        this.writeVectorField();
        this.writeConstructor();
        this.writeApplyImpl();
        this.writeGetElementImpl();
        this.writeLengthImpl();
        this.writeIsConstantAccessTimeImpl();
        this.writeGetOperandsImpl();
        this.writeGetComputationNameImpl();
        this.writeClassEnd();
        return JitClassLoader.defineClass(CompiledLoopBody.class, this.thisClass.getInternalName().replace('/', '.'), this.cw.toByteArray());
    }

    private void startClass() {
        this.cw = new ClassWriter(2);
        this.cv = new TraceClassVisitor(this.cw, new PrintWriter(System.out));
        this.cv.visit(50, 33, this.thisClass.getInternalName(), null, this.superClass.getInternalName(), new String[]{Type.getInternalName(MemoizedComputation.class)});
    }

    private void writeVectorField() {
        this.cv.visitField(2, "vector", Type.getDescriptor(Vector.class), null, null);
    }

    private void writeConstructor() {
        MethodVisitor mv = this.cv.visitMethod(1, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, VECTOR_TYPE, ATTRIBUTE_MAP_TYPE), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(183, this.superClass.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, ATTRIBUTE_MAP_TYPE), false);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, this.thisClass.getInternalName(), "vector", VECTOR_TYPE.getDescriptor());
        mv.visitInsn(177);
        mv.visitMaxs(2, 3);
        mv.visitEnd();
    }

    private void writeGetOperandsImpl() {
        MethodVisitor mv = this.cv.visitMethod(1, "getOperands", "()[Lorg/renjin/sexp/Vector;", null, null);
        mv.visitCode();
        mv.visitInsn(4);
        mv.visitTypeInsn(189, Type.getInternalName(Vector.class));
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.thisClass.getInternalName(), "vector", VECTOR_TYPE.getDescriptor());
        mv.visitInsn(83);
        mv.visitInsn(176);
        mv.visitMaxs(3, 1);
        mv.visitEnd();
    }

    private void writeLengthImpl() {
        MethodVisitor mv = this.cv.visitMethod(1, "length", "()I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.thisClass.getInternalName(), "vector", VECTOR_TYPE.getDescriptor());
        mv.visitMethodInsn(185, "org/renjin/sexp/SEXP", "length", "()I", true);
        mv.visitInsn(172);
        mv.visitMaxs(3, 1);
        mv.visitEnd();
    }

    private void writeApplyImpl() {
        MethodVisitor mv = this.cv.visitMethod(9, "apply", this.applySignature(), null, null);
        mv.visitCode();
        VariableSlots slots = new VariableSlots(this.elementBounds.storageType().getSize(), this.function.getTypes());
        ApplyMethodContext emitContext = new ApplyMethodContext(this.function.getCfg(), this.elementFormalName, this.elementBounds.storageType(), slots);
        this.function.write(emitContext, new InstructionAdapter(mv));
        mv.visitMaxs(3, 1);
        mv.visitEnd();
    }

    private String applySignature() {
        return Type.getMethodDescriptor(this.resultBounds.storageType(), this.elementBounds.storageType());
    }

    private void writeGetElementImpl() {
        MethodVisitor mv = this.cv.visitMethod(1, "getElementAsDouble", "(I)D", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.thisClass.getInternalName(), "vector", VECTOR_TYPE.getDescriptor());
        mv.visitVarInsn(21, 1);
        mv.visitMethodInsn(185, VECTOR_TYPE.getInternalName(), "getElementAsInt", "(I)I", true);
        mv.visitMethodInsn(184, this.thisClass.getInternalName(), "apply", this.applySignature(), false);
        mv.visitInsn(175);
        mv.visitMaxs(4, 2);
    }

    private void writeIsConstantAccessTimeImpl() {
        MethodVisitor mv = this.cv.visitMethod(1, "isConstantAccessTime", "()Z", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.thisClass.getInternalName(), "vector", VECTOR_TYPE.getDescriptor());
        mv.visitMethodInsn(185, Type.getInternalName(DeferredComputation.class), "isConstantAccessTime", "()Z", true);
        mv.visitInsn(172);
        mv.visitMaxs(3, 1);
        mv.visitEnd();
    }

    private void writeGetComputationNameImpl() {
        MethodVisitor mv = this.cv.visitMethod(1, "getComputationName", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitLdcInsn("apply" + this.uniqueId);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void writeClassEnd() {
        this.cv.visitEnd();
    }
}

