/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.codegen;

import java.util.HashMap;
import java.util.Map;
import org.renjin.compiler.TypeSolver;
import org.renjin.compiler.codegen.VariableStorage;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.expressions.LValue;

public class VariableSlots {
    private final Map<LValue, VariableStorage> storage = new HashMap<LValue, VariableStorage>();
    private final int firstSlot;
    private int nextSlot = 0;

    public VariableSlots(int parameterSize, TypeSolver types) {
        this.firstSlot = parameterSize;
        for (Map.Entry<LValue, ValueBounds> entry : types.getVariables().entrySet()) {
            LValue variable = entry.getKey();
            ValueBounds bounds = entry.getValue();
            if (bounds == null) continue;
            this.storage.put(variable, new VariableStorage(this.firstSlot + this.nextSlot, bounds.storageType()));
            this.nextSlot += variable.getType().getSize();
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Map.Entry<LValue, VariableStorage> entry : this.storage.entrySet()) {
            s.append(entry.getKey()).append(" => ").append(entry.getValue()).append("\n");
        }
        return s.toString();
    }

    public int getNumLocals() {
        return this.nextSlot;
    }

    public int getSlot(LValue lValue) {
        return this.storage.get(lValue).getSlotIndex();
    }

    public VariableStorage getStorage(LValue lhs) {
        return this.storage.get(lhs);
    }
}

