/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir;

import org.apache.commons.math.complex.Complex;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Function;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Logical;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.RawVector;
import org.renjin.sexp.S4Object;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;

public class TypeSet {
    public static final int LIST = 2;
    public static final int NULL = 4;
    public static final int LOGICAL = 8;
    public static final int INT = 16;
    public static final int DOUBLE = 32;
    public static final int STRING = 64;
    public static final int COMPLEX = 128;
    public static final int RAW = 256;
    public static final int SYMBOL = 512;
    public static final int FUNCTION = 1024;
    public static final int ENVIRONMENT = 2048;
    public static final int PAIRLIST = 4096;
    public static final int S4 = 8192;
    public static final int ANY_ATOMIC_VECTOR = 508;
    public static final int ANY_VECTOR = 510;
    public static final int ANY_TYPE = 8190;
    public static final int NUMERIC = 48;

    public static int of(SEXP constant) {
        if (constant instanceof ListVector) {
            return 2;
        }
        if (constant instanceof Null) {
            return 4;
        }
        if (constant instanceof LogicalVector) {
            return 8;
        }
        if (constant instanceof RawVector) {
            return 256;
        }
        if (constant instanceof IntVector) {
            return 16;
        }
        if (constant instanceof DoubleVector) {
            return 32;
        }
        if (constant instanceof ComplexVector) {
            return 128;
        }
        if (constant instanceof StringVector) {
            return 64;
        }
        if (constant instanceof Symbol) {
            return 512;
        }
        if (constant instanceof Environment) {
            return 2048;
        }
        if (constant instanceof PairList) {
            return 4096;
        }
        if (constant instanceof Function) {
            return 1024;
        }
        if (constant instanceof S4Object) {
            return 8192;
        }
        throw new UnsupportedOperationException("TODO: " + constant.getClass().getName());
    }

    public static int of(Class type) {
        if (type.equals(Integer.TYPE)) {
            return 16;
        }
        if (type.equals(Double.TYPE)) {
            return 32;
        }
        if (type.equals(Boolean.TYPE) || type.equals(Logical.class)) {
            return 8;
        }
        if (type.equals(String.class)) {
            return 64;
        }
        if (type.equals(Complex.class)) {
            return 128;
        }
        if (type.equals(IntVector.class)) {
            return 16;
        }
        if (type.equals(ListVector.class)) {
            return 2;
        }
        if (type.equals(AtomicVector.class)) {
            return 508;
        }
        if (type.equals(SEXP.class)) {
            return 8190;
        }
        throw new UnsupportedOperationException("type: " + type);
    }

    public static int accepts(Class type) {
        if (type.equals(Integer.TYPE)) {
            return 24;
        }
        if (type.equals(Double.TYPE)) {
            return 56;
        }
        if (type.equals(Boolean.TYPE)) {
            return 8;
        }
        if (type.equals(Byte.TYPE)) {
            return 256;
        }
        if (type.equals(String.class)) {
            return 64;
        }
        if (type.equals(Complex.class)) {
            return 128;
        }
        if (type.equals(StringVector.class)) {
            return 64;
        }
        if (type.equals(IntVector.class)) {
            return 16;
        }
        if (type.equals(DoubleVector.class)) {
            return 32;
        }
        if (type.equals(ComplexVector.class)) {
            return 128;
        }
        if (type.equals(RawVector.class)) {
            return 256;
        }
        if (type.equals(Vector.class)) {
            return 510;
        }
        if (type.equals(AtomicVector.class)) {
            return 508;
        }
        if (type.equals(SEXP.class)) {
            return 8190;
        }
        throw new UnsupportedOperationException("type: " + type);
    }

    public static String implicitClass(int typeSet) {
        switch (typeSet) {
            case 2: {
                return "list";
            }
            case 4: {
                return "NULL";
            }
            case 16: {
                return "integer";
            }
            case 32: {
                return "double";
            }
            case 8: {
                return "logical";
            }
            case 64: {
                return "character";
            }
            case 128: {
                return "complex";
            }
            case 256: {
                return "raw";
            }
            case 512: {
                return "name";
            }
            case 1024: {
                return "function";
            }
            case 2048: {
                return "environment";
            }
            case 4096: {
                return "pairlist";
            }
        }
        return null;
    }

    public static boolean matches(Class clazz, int typeSet) {
        int mask = TypeSet.accepts(clazz);
        int inverseMask = mask ^ 0x1FFE;
        return (typeSet & inverseMask) == 0;
    }

    public static String toString(int mask) {
        if (mask == 8190) {
            return "*";
        }
        StringBuilder s = new StringBuilder();
        TypeSet.appendType(s, "list", mask, 2);
        TypeSet.appendType(s, "null", mask, 4);
        TypeSet.appendType(s, "int", mask, 16);
        TypeSet.appendType(s, "double", mask, 32);
        TypeSet.appendType(s, "logical", mask, 8);
        TypeSet.appendType(s, "character", mask, 64);
        TypeSet.appendType(s, "complex", mask, 128);
        TypeSet.appendType(s, "raw", mask, 256);
        TypeSet.appendType(s, "symbol", mask, 512);
        TypeSet.appendType(s, "function", mask, 1024);
        TypeSet.appendType(s, "environment", mask, 2048);
        TypeSet.appendType(s, "pairlist", mask, 4096);
        TypeSet.appendType(s, "S4", mask, 8192);
        return s.toString();
    }

    private static void appendType(StringBuilder sb, String name, int mask, int bit) {
        if ((mask & bit) != 0) {
            if (sb.length() > 1) {
                sb.append("|");
            }
            sb.append(name);
        }
    }

    public static boolean isDefinitelyNumeric(ValueBounds subscript) {
        return TypeSet.isDefinitelyNumeric(subscript.getTypeSet());
    }

    public static boolean isDefinitelyNumeric(int typeSet) {
        return (typeSet & 0x30) != 0 && (typeSet & 0xFFFFFFCF) == 0;
    }

    public static int widestVectorType(int x, int y) {
        return Math.max(x, y);
    }

    public static int elementOf(int typeSet) {
        if ((typeSet & 0xFFFFFE03) != 0) {
            return 8190;
        }
        return typeSet;
    }

    public static boolean isDefinitelyAtomic(int typeSet) {
        return (typeSet & 0x1FC) != 0 && (typeSet & 0xFFFFFE03) == 0;
    }
}

