/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.renjin.compiler.NotCompilableException;
import org.renjin.compiler.builtins.ArgumentBounds;
import org.renjin.compiler.ir.TypeSet;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.exception.InvalidSyntaxException;
import org.renjin.eval.ArgumentMatcher;
import org.renjin.eval.Context;
import org.renjin.eval.MatchedArgumentPositions;
import org.renjin.packaging.SerializedPromise;
import org.renjin.primitives.S3;
import org.renjin.primitives.packaging.Namespace;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.repackaged.guava.collect.Sets;
import org.renjin.repackaged.guava.primitives.Ints;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Frame;
import org.renjin.sexp.Function;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.Promise;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;

public class RuntimeState {
    private Context context;
    private Environment rho;
    private Environment methodTable;
    private Map<Symbol, Function> resolvedFunctions = Maps.newHashMap();
    private Map<Symbol, List<Environment>> s4GenericMethodTables = new HashMap<Symbol, List<Environment>>();
    private Map<Symbol, List<Environment>> s4GroupMethodTables = new HashMap<Symbol, List<Environment>>();
    public static final Set<String> GROUPS = Sets.newHashSet("Ops", "Math", "Summary");
    private static final Set<String> ARITH_GROUP = Sets.newHashSet("+", "-", "*", "^", "%%", "%/%", "/");
    private static final Set<String> COMPARE_GROUP = Sets.newHashSet("==", ">", "<", "!=", "<=", ">=");
    private static final Set<String> LOGIC_GROUP = Sets.newHashSet("&", "&&", "|", "||", "xor");
    private static final Set<String> SPECIAL = Sets.newHashSet("$", "$<-");

    public RuntimeState(Context context, Environment rho) {
        this.context = context;
        this.rho = rho;
    }

    public RuntimeState(RuntimeState parentState, Environment enclosingEnvironment) {
        this(parentState.context, enclosingEnvironment);
        SEXP methodTableSexp = enclosingEnvironment.getVariable(S3.METHODS_TABLE);
        if (methodTableSexp instanceof Promise) {
            throw new NotCompilableException(S3.METHODS_TABLE, S3.METHODS_TABLE + " is not evaluated.");
        }
        if (methodTableSexp instanceof Environment) {
            this.methodTable = (Environment)methodTableSexp;
        }
    }

    public PairList getEllipsesVariable() {
        SEXP ellipses = this.rho.getEllipsesVariable();
        if (ellipses == Symbol.UNBOUND_VALUE) {
            throw new InvalidSyntaxException("'...' used in an incorrect context.");
        }
        return (PairList)ellipses;
    }

    public SEXP findVariable(Symbol name) {
        SEXP value = null;
        for (Environment environment2 = this.rho; environment2 != Environment.EMPTY; environment2 = environment2.getParent()) {
            if (environment2.isActiveBinding(name)) {
                throw new NotCompilableException(name, "Active Binding encountered");
            }
            value = this.rho.findVariable(this.context, name);
            if (!(value instanceof Promise)) continue;
            Promise promisedValue = (Promise)value;
            if (promisedValue.isEvaluated()) {
                value = promisedValue.force(this.context);
                continue;
            }
            throw new NotCompilableException(name, "Unevaluated promise encountered");
        }
        if (value == null) {
            throw new NotCompilableException(name, "Symbol not found. Should not reach here!");
        }
        return value;
    }

    public Function findFunction(Symbol functionName) {
        Function f = this.findFunctionIfExists(functionName);
        if (f != null) {
            return f;
        }
        throw new NotCompilableException(functionName, "Could not find function " + functionName);
    }

    public Function findFunctionIfExists(Symbol functionName) {
        if (this.resolvedFunctions.containsKey(functionName)) {
            return this.resolvedFunctions.get(functionName);
        }
        for (Environment environment2 = this.rho; environment2 != Environment.EMPTY; environment2 = environment2.getParent()) {
            Function f = this.isFunction(functionName, environment2.getVariable(this.context, functionName));
            if (f == null) continue;
            this.resolvedFunctions.put(functionName, f);
            return f;
        }
        return null;
    }

    private Function isFunction(Symbol functionName, SEXP exp2) {
        if (exp2 instanceof Function) {
            return (Function)exp2;
        }
        if (exp2 instanceof SerializedPromise) {
            return this.isFunction(functionName, exp2.force(this.context));
        }
        if (exp2 instanceof Promise) {
            Promise promise = (Promise)exp2;
            if (promise.isEvaluated()) {
                return this.isFunction(functionName, promise.getValue());
            }
            throw new NotCompilableException(functionName, "Symbol " + functionName + " cannot be resolved to a function " + " an enclosing environment has a binding of the same name to an unevaluated promise");
        }
        return null;
    }

    public Map<Symbol, Function> getResolvedFunctions() {
        return this.resolvedFunctions;
    }

    public Function findMethod(String generic, String group, StringVector objectClasses) {
        Function method = null;
        for (String className : objectClasses) {
            method = this.findMethod(generic, group, className);
            if (method == null) continue;
            return method;
        }
        return this.findMethod(generic, group, "default");
    }

    private Function findMethod(String generic, String group, String className) {
        Function method = this.findMethod(generic, className);
        if (method != null) {
            return method;
        }
        if (group != null && (method = this.findMethod(group, className)) != null) {
            return method;
        }
        return null;
    }

    private Function findMethod(String generic, String className) {
        Symbol method = Symbol.get(generic + "." + className);
        Function function2 = this.findFunctionIfExists(method);
        if (function2 != null) {
            return function2;
        }
        if (this.methodTable != null) {
            SEXP functionSexp = this.methodTable.getVariable(method);
            if (functionSexp instanceof Promise) {
                throw new NotCompilableException(method, "Unevaluated entry in " + S3.METHODS_TABLE);
            }
            if (functionSexp instanceof Function) {
                return (Function)functionSexp;
            }
        }
        return null;
    }

    public void findS4methodTables(String generic, Symbol opName, List<ArgumentBounds> args2) {
        List<Environment> groupMethodTables = null;
        List<Environment> genericMethodTables = null;
        genericMethodTables = RuntimeState.findMethodTable(this.context, opName);
        if ("Ops".equals(generic)) {
            groupMethodTables = RuntimeState.findOpsMethodTable(this.context, generic);
        }
        if (genericMethodTables != null) {
            this.s4GenericMethodTables.put(opName, genericMethodTables);
        }
        if (groupMethodTables != null) {
            this.s4GroupMethodTables.put(opName, genericMethodTables);
        }
    }

    private static List<Environment> findMethodTable(Context context, Symbol opName) {
        ArrayList<Environment> methodTableList = new ArrayList<Environment>();
        if (SPECIAL.contains(opName)) {
            Namespace methodsNamespace = context.getNamespaceRegistry().getNamespace(context, "methods");
            Frame methodFrame = methodsNamespace.getNamespaceEnvironment().getFrame();
            SEXP methodTableMethodsPkg = methodFrame.getVariable(opName).force(context);
            if (methodTableMethodsPkg == Symbol.UNBOUND_VALUE || !(methodTableMethodsPkg instanceof Environment)) {
                return null;
            }
            methodTableList.add((Environment)methodTableMethodsPkg);
        } else {
            SEXP methodTableGlobalEnv = context.getGlobalEnvironment().getFrame().getVariable(opName);
            if (methodTableGlobalEnv != Symbol.UNBOUND_VALUE && methodTableGlobalEnv instanceof Environment) {
                methodTableList.add((Environment)methodTableGlobalEnv);
            }
            for (Symbol loadedNamespace : context.getNamespaceRegistry().getLoadedNamespaces()) {
                String packageName = loadedNamespace.getPrintName();
                Namespace packageNamespace = context.getNamespaceRegistry().getNamespace(context, packageName);
                Environment packageEnvironment = packageNamespace.getNamespaceEnvironment();
                SEXP methodTablePackage = packageEnvironment.getFrame().getVariable(opName).force(context);
                if (!(methodTablePackage instanceof Environment)) continue;
                methodTableList.add((Environment)methodTablePackage);
            }
        }
        return methodTableList.size() == 0 ? null : methodTableList;
    }

    private static List<Environment> findOpsMethodTable(Context context, String generic) {
        ArrayList<Environment> methodTableList = new ArrayList<Environment>();
        Frame globalFrame = context.getGlobalEnvironment().getFrame();
        SEXP methodTableGlobalEnv = RuntimeState.getMethodTable(context, generic, globalFrame);
        if (methodTableGlobalEnv instanceof Environment) {
            methodTableList.add((Environment)methodTableGlobalEnv);
        }
        for (Symbol packageSymbol : context.getNamespaceRegistry().getLoadedNamespaces()) {
            Namespace packageNamespace;
            Frame packageFrame;
            SEXP methodTablePackage;
            String packageName = packageSymbol.getPrintName();
            Collection<Symbol> exports = context.getNamespaceRegistry().getNamespace(context, packageName).getExports();
            if (!exports.contains(Symbol.get("Arith")) && !exports.contains(Symbol.get("Compare")) && !exports.contains(Symbol.get("Logic")) && !exports.contains(Symbol.get(generic)) || !((methodTablePackage = RuntimeState.getMethodTable(context, generic, packageFrame = (packageNamespace = context.getNamespaceRegistry().getNamespace(context, packageName)).getNamespaceEnvironment().getFrame())) instanceof Environment) || ((Environment)methodTablePackage).getFrame().getSymbols().size() <= 0) continue;
            methodTableList.add((Environment)methodTablePackage);
        }
        if (methodTableList.size() == 0) {
            return null;
        }
        return methodTableList;
    }

    private static SEXP getMethodTable(Context context, String generic, Frame packageFrame) {
        SEXP methodTable = null;
        if (ARITH_GROUP.contains(generic)) {
            String[] groups = new String[]{".__T__Arith:base", ".__T__Ops:base"};
            methodTable = RuntimeState.getMethod(context, packageFrame, groups);
        } else if (COMPARE_GROUP.contains(generic)) {
            String[] groups = new String[]{".__T__Compare:methods", ".__T__Ops:base"};
            methodTable = RuntimeState.getMethod(context, packageFrame, groups);
        } else if (LOGIC_GROUP.contains(generic)) {
            String[] groups = new String[]{".__T__Logic:base", ".__T__Ops:base"};
            methodTable = RuntimeState.getMethod(context, packageFrame, groups);
        }
        return methodTable;
    }

    private static SEXP getMethod(Context context, Frame frame2, String[] groups) {
        Environment methodTable = null;
        for (int i = 0; i < groups.length && methodTable == null; ++i) {
            SEXP foundMethodTable = frame2.getVariable(Symbol.get(groups[i])).force(context);
            methodTable = foundMethodTable instanceof Environment ? (Environment)foundMethodTable : null;
        }
        return methodTable;
    }

    public boolean hasS4MethodTable(Symbol opName) {
        return this.s4GenericMethodTables.containsKey(opName) || this.s4GroupMethodTables.containsKey(opName);
    }

    public int[] computeSignatureLength(Symbol opName) {
        List<Environment> methodTable = this.s4GenericMethodTables.containsKey(opName) ? this.s4GenericMethodTables.get(opName) : this.s4GroupMethodTables.get(opName);
        int[] length2 = new int[methodTable.size()];
        for (int i = 0; i < methodTable.size(); ++i) {
            if (methodTable.get(i).getFrame().getSymbols().iterator().hasNext()) {
                String methodName = methodTable.get(i).getFrame().getSymbols().iterator().next().getPrintName();
                length2[i] = methodName.split("#").length;
                continue;
            }
            length2[i] = 0;
        }
        return length2;
    }

    public Map<String, List<List<S3.MethodRanking>>> generateSignatures(Symbol opName, List<ArgumentBounds> arguments, int[] depth) {
        HashMap<String, List<List<S3.MethodRanking>>> mapListMethods = new HashMap<String, List<List<S3.MethodRanking>>>();
        HashMap<String, List<Environment>> mapMethodTableLists = new HashMap<String, List<Environment>>();
        if (this.s4GenericMethodTables.size() > 0) {
            mapMethodTableLists.put("generic", this.s4GenericMethodTables.get(opName));
        }
        if (this.s4GroupMethodTables.size() > 0) {
            mapMethodTableLists.put("group", this.s4GroupMethodTables.get(opName));
        }
        for (int e = 0; e < mapMethodTableLists.size(); ++e) {
            String type = mapMethodTableLists.keySet().toArray(new String[0])[e];
            List methodTableList = (List)mapMethodTableLists.get(type);
            ArrayList listSignatures = new ArrayList();
            for (int listIdx = 0; listIdx < methodTableList.size(); ++listIdx) {
                Environment methodTable = (Environment)methodTableList.get(listIdx);
                int currentDepth = depth[listIdx];
                Symbol methodSymbol = methodTable.getFrame().getSymbols().iterator().next();
                Closure genericClosure = (Closure)methodTable.getFrame().getVariable(methodSymbol);
                PairList formals2 = genericClosure.getFormals();
                ArgumentMatcher argumentMatcher = new ArgumentMatcher(formals2);
                String[] argNames = new String[arguments.size()];
                for (int i = 0; i < arguments.size(); ++i) {
                    argNames[i] = arguments.get(i).getName();
                }
                MatchedArgumentPositions matchedArguments = argumentMatcher.match(argNames);
                S3.ArgumentSignature[] argSignatures = RuntimeState.computeArgumentSignatures(this.context, matchedArguments, arguments, currentDepth);
                int numberOfPossibleSignatures = 1;
                for (int i = 0; i < argSignatures.length; ++i) {
                    numberOfPossibleSignatures *= argSignatures[i].getArgument().length;
                }
                ArrayList<S3.MethodRanking> possibleSignatures = new ArrayList<S3.MethodRanking>(numberOfPossibleSignatures);
                int argumentClassIdx = 0;
                int repeat = 1;
                int repeatIdx = 1;
                for (int col2 = 0; col2 < depth[listIdx]; ++col2) {
                    int numberOfClassesCurrentArgument = argSignatures[col2].getArgument().length;
                    int row2 = 0;
                    while (row2 < numberOfPossibleSignatures) {
                        if (argumentClassIdx == numberOfClassesCurrentArgument) {
                            argumentClassIdx = 0;
                        }
                        S3.ArgumentSignature argSignature = argSignatures[col2];
                        String signature = argSignature.getArgument(argumentClassIdx);
                        if (possibleSignatures.isEmpty() || possibleSignatures.size() < row2 + 1 || possibleSignatures.get(row2) == null) {
                            int[] distance = argSignature.getDistanceAsArray(argumentClassIdx);
                            possibleSignatures.add(row2, new S3.MethodRanking(signature, distance));
                        } else {
                            int distance = argSignature.getDistance(argumentClassIdx);
                            possibleSignatures.set(row2, ((S3.MethodRanking)possibleSignatures.get(row2)).append(signature, distance));
                        }
                        if (repeat == 1) {
                            ++argumentClassIdx;
                        }
                        if (repeat != 1 && repeatIdx == repeat) {
                            repeatIdx = 0;
                            ++argumentClassIdx;
                        }
                        ++row2;
                        ++repeatIdx;
                    }
                    repeatIdx = 1;
                    argumentClassIdx = 0;
                    repeat *= numberOfClassesCurrentArgument;
                }
                listSignatures.add(possibleSignatures);
            }
            mapListMethods.put(type, listSignatures);
        }
        return mapListMethods;
    }

    private static S3.ArgumentSignature[] computeArgumentSignatures(Context context, MatchedArgumentPositions match2, List<ArgumentBounds> arguments, int currentDepth) {
        S3.ArgumentSignature[] argSignatures = new S3.ArgumentSignature[currentDepth];
        int idx = 0;
        for (int i = 0; i < currentDepth; ++i) {
            Symbol formal = match2.getFormalName(i);
            ValueBounds value = arguments.get(match2.getMatchedFormals().get(formal)).getBounds();
            String argClass = value.getConstantClassAttribute() != Null.INSTANCE ? value.getConstantClassAttribute().getElementAsString(0) : TypeSet.implicitClass(value.getTypeSet());
            argSignatures[idx] = RuntimeState.getClassAndDistance(context, argClass);
            ++idx;
        }
        return argSignatures;
    }

    private static S3.ArgumentSignature getClassAndDistance(Context context, String argClass) {
        ArrayList<Integer> distances = new ArrayList<Integer>();
        ArrayList<String> classes = new ArrayList<String>();
        classes.add(argClass);
        distances.add(0);
        Symbol argClassObjectName = Symbol.get(".__C__" + argClass);
        Frame globalFrame = context.getGlobalEnvironment().getFrame();
        AttributeMap map = globalFrame.getVariable(argClassObjectName).getAttributes();
        SEXP containsSlot = map.get("contains");
        AtomicVector argSuperClasses = containsSlot.getNames();
        for (int i = 0; i < argSuperClasses.length(); ++i) {
            SEXP distanceSlot = ((ListVector)containsSlot).get(i).getAttributes().get("distance");
            distances.add(((Vector)distanceSlot).getElementAsInt(0));
            classes.add(((Vector)argSuperClasses).getElementAsString(i));
        }
        int max2 = (Integer)Collections.max(distances);
        if (!classes.contains("ANY") && !classes.contains("NULL")) {
            distances.add(max2 + 1);
            classes.add("ANY");
        }
        return new S3.ArgumentSignature(classes.toArray(new String[0]), Ints.toArray(distances));
    }

    public Map<String, List<S3.SelectedMethod>> findMatchingMethods(Symbol opName, Map<String, List<List<S3.MethodRanking>>> signatures) {
        HashMap<String, List<S3.SelectedMethod>> methods = new HashMap<String, List<S3.SelectedMethod>>();
        ArrayList<S3.SelectedMethod> selectedMethods = new ArrayList<S3.SelectedMethod>();
        HashMap<String, List<Environment>> mapMethodTableLists = new HashMap<String, List<Environment>>();
        if (this.s4GenericMethodTables.containsKey(opName)) {
            mapMethodTableLists.put("generic", this.s4GenericMethodTables.get(opName));
        }
        if (this.s4GroupMethodTables.containsKey(opName)) {
            mapMethodTableLists.put("group", this.s4GroupMethodTables.get(opName));
        }
        for (int e = 0; e < signatures.size(); ++e) {
            String type = signatures.keySet().toArray(new String[0])[e];
            List<List<S3.MethodRanking>> rankings = signatures.get(type);
            List methodTableList = (List)mapMethodTableLists.get(type);
            for (int i = 0; i < rankings.size(); ++i) {
                List<S3.MethodRanking> rankedMethodsList = rankings.get(i);
                String inputSignature = rankedMethodsList.get(0).getSignature();
                for (S3.MethodRanking rankedMethod : rankedMethodsList) {
                    String signature = rankedMethod.getSignature();
                    double rank2 = rankedMethod.getRank();
                    int[] distance = rankedMethod.getDistances();
                    boolean has0 = rankedMethod.hasZeroDistanceArgument();
                    Symbol signatureSymbol = Symbol.get(signature);
                    SEXP function2 = ((Environment)methodTableList.get(i)).getFrame().getVariable(signatureSymbol).force(this.context);
                    if (!(function2 instanceof Closure)) continue;
                    selectedMethods.add(new S3.SelectedMethod((Closure)function2, type, rank2, distance, signature, signatureSymbol, inputSignature, has0));
                }
            }
            if (selectedMethods.size() <= 0) continue;
            Collections.sort(selectedMethods);
            methods.put(type, selectedMethods);
        }
        return methods;
    }
}

