/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.functions;

import java.util.List;
import org.renjin.compiler.ir.exception.InvalidSyntaxException;
import org.renjin.compiler.ir.tac.IRArgument;
import org.renjin.compiler.ir.tac.IRBodyBuilder;
import org.renjin.compiler.ir.tac.expressions.BuiltinCall;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.functions.FunctionCallTranslator;
import org.renjin.compiler.ir.tac.functions.TranslationContext;
import org.renjin.compiler.ir.tac.statements.ExprStatement;
import org.renjin.primitives.Primitives;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.Symbol;

public class InternalCallTranslator
extends FunctionCallTranslator {
    @Override
    public Expression translateToExpression(IRBodyBuilder builder, TranslationContext context, Function resolvedFunction, FunctionCall call2) {
        Object argument = call2.getArgument(0);
        if (!(argument instanceof FunctionCall)) {
            throw new InvalidSyntaxException(".Internal() expects a language object as its only argument");
        }
        FunctionCall primitiveCall = (FunctionCall)argument;
        if (!(primitiveCall.getFunction() instanceof Symbol)) {
            throw new InvalidSyntaxException("Invalid .Internal() argument");
        }
        Symbol internalName = (Symbol)primitiveCall.getFunction();
        Primitives.Entry entry = Primitives.getInternalEntry(internalName);
        if (entry == null) {
            throw new InvalidSyntaxException("No such .Internal function '" + internalName + "'");
        }
        List<IRArgument> internalArguments = builder.translateArgumentList(context, primitiveCall.getArguments());
        return new BuiltinCall(builder.getRuntimeState(), call2, internalName.getPrintName(), internalArguments);
    }

    @Override
    public void addStatement(IRBodyBuilder builder, TranslationContext context, Function resolvedFunction, FunctionCall call2) {
        builder.addStatement(new ExprStatement(this.translateToExpression(builder, context, resolvedFunction, call2)));
    }
}

