/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.eval;

import org.renjin.eval.ClosureDispatcher;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.primitives.special.ReturnException;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Frame;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.PairList;
import org.renjin.sexp.Promise;
import org.renjin.sexp.PromisePairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class Calls {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SEXP applyClosure(Closure closure, Context context, Environment callingEnvironment, FunctionCall call2, PairList promisedArgs, Frame suppliedEnvironment) {
        Context functionContext = context.beginFunction(callingEnvironment, call2, closure, promisedArgs);
        Environment functionEnvironment = functionContext.getEnvironment();
        try {
            ClosureDispatcher.matchArgumentsInto(closure.getFormals(), promisedArgs, functionEnvironment);
            for (Symbol name : suppliedEnvironment.getSymbols()) {
                functionEnvironment.setVariableUnsafe(name, suppliedEnvironment.getVariable(name));
            }
            SEXP i$ = functionContext.evaluate(closure.getBody(), functionEnvironment);
            return i$;
        }
        catch (ReturnException e) {
            if (e.getEnvironment() != functionEnvironment) {
                throw e;
            }
            SEXP sEXP = e.getValue();
            return sEXP;
        }
        finally {
            functionContext.exit();
        }
    }

    public static PairList promiseArgs(PairList argumentList, Context context, Environment rho) {
        PairList.Builder list2 = new PairList.Builder();
        for (PairList.Node node : argumentList.nodes()) {
            if (node.getValue().equals(Symbols.ELLIPSES)) {
                SEXP ellipsesValue = rho.findVariable(context, Symbols.ELLIPSES);
                if (ellipsesValue == Symbol.UNBOUND_VALUE) {
                    throw new EvalException("'...' used in an incorrect context", new Object[0]);
                }
                PromisePairList dotExp = (PromisePairList)ellipsesValue;
                for (PairList.Node dotNode : dotExp.nodes()) {
                    list2.add(dotNode.getRawTag(), dotNode.getValue());
                }
                continue;
            }
            if (node.getValue() == Symbol.MISSING_ARG) {
                list2.add(node.getRawTag(), node.getValue());
                continue;
            }
            list2.add(node.getRawTag(), (SEXP)Promise.repromise(rho, node.getValue()));
        }
        return list2.build();
    }
}

