/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.math.BigInteger;
import java.util.Arrays;
import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.MallocThunk;
import org.renjin.gcc.runtime.OffsetPtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Realloc;

public class LongPtr
extends AbstractPtr {
    public static final int BYTES = 8;
    public static final LongPtr NULL = new LongPtr();
    public final long[] array;
    public final int offset;

    private LongPtr() {
        this.array = null;
        this.offset = 0;
    }

    public LongPtr(long[] array2, int offset) {
        this.array = array2;
        this.offset = offset;
    }

    public LongPtr(long ... array2) {
        this.array = array2;
        this.offset = 0;
    }

    public long[] getArray() {
        return this.array;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getOffsetInBytes() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public LongPtr realloc(int newSizeInBytes) {
        return new LongPtr(Realloc.realloc(this.array, this.offset, newSizeInBytes / 8));
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        if (bytes == 0) {
            return this;
        }
        if (bytes % 8 == 0) {
            return new LongPtr(this.array, this.offset + bytes / 8);
        }
        return new OffsetPtr(this, this.offset * 8 + bytes);
    }

    @Override
    public byte getByte(int offset) {
        int bytes = this.offset * 8 + offset;
        int index = bytes / 8;
        long elementBits = this.array[index];
        int shift = bytes % 8 * 8;
        return (byte)(elementBits >>> shift);
    }

    @Override
    public void setByte(int offset, byte value) {
        int bytes = this.offset * 8 + offset;
        int index = bytes / 8;
        int shift = bytes % 8 * 8;
        long element = this.array[index];
        long updateMask = 255 << shift;
        long update = (long)value << shift & updateMask;
        this.array[index] = (element &= updateMask ^ 0xFFFFFFFFFFFFFFFFL) | update;
    }

    @Override
    public int toInt() {
        return this.offset * 8;
    }

    @Override
    public boolean isNull() {
        return this.array == null && this.offset == 0;
    }

    public long unwrap() {
        return this.array[this.offset];
    }

    public String toString() {
        return this.offset + "+" + Arrays.toString(this.array);
    }

    public static int memcmp(LongPtr x, LongPtr y, int n) {
        return LongPtr.memcmp(x.array, x.offset, y.array, y.offset, n);
    }

    public static int memcmp(long[] x, int xi, long[] y, int yi, int n) {
        while (n > 0) {
            long vx = x[xi];
            long vy = y[yi];
            if (vx != vy || n < 8) {
                return LongPtr.memcmp(vx, vy, n);
            }
            ++xi;
            ++yi;
            n -= 8;
        }
        return 0;
    }

    public static int memcmp(long x, long y, int n) {
        for (int i = 0; i < n; ++i) {
            int xb = (int)(x & 0xFFL);
            int yb = (int)(y & 0xFFL);
            if (xb < yb) {
                return -1;
            }
            if (xb > yb) {
                return 1;
            }
            x >>= 8;
            y >>= 8;
        }
        return 0;
    }

    public static void memset(double[] str, int strOffset, int c2, int n) {
        assert (n % 64 == 0);
        Arrays.fill(str, strOffset, strOffset + c2 / 64, (double)LongPtr.memset(c2));
    }

    public static long memset(int c2) {
        return ((long)c2 & 0xFFL) << 56 | ((long)c2 & 0xFFL) << 48 | ((long)c2 & 0xFFL) << 40 | ((long)c2 & 0xFFL) << 32 | ((long)c2 & 0xFFL) << 24 | ((long)c2 & 0xFFL) << 16 | ((long)c2 & 0xFFL) << 8 | (long)c2 & 0xFFL;
    }

    public static LongPtr cast(Object voidPointer) {
        if (voidPointer instanceof MallocThunk) {
            return ((MallocThunk)voidPointer).longPtr();
        }
        if (voidPointer == null) {
            return NULL;
        }
        return (LongPtr)voidPointer;
    }

    public static void memcpy(LongPtr x, LongPtr y, int numBytes) {
        int offsetS;
        long[] arrayS = y.getArray();
        int restY = arrayS.length - (offsetS = y.getOffset());
        if (restY > 0) {
            long[] carray = new long[numBytes];
            int i = 0;
            for (int j = offsetS; j < arrayS.length && i < numBytes; ++j, ++i) {
                carray[i] = arrayS[j];
            }
            x = new LongPtr(carray);
        }
    }

    public static double unsignedInt64ToReal64(long i) {
        if (i >= 0L) {
            return i;
        }
        int upper = (int)(i >>> 32);
        int lower = (int)i;
        long lowerLong = (long)lower & 0xFFFFFFFFL;
        long upperLong = (long)upper & 0xFFFFFFFFL;
        return (double)lowerLong + (double)upperLong * 4.294967296E9;
    }

    public static long unsignedDivide(long dividend, long divisor) {
        long quotient;
        if (divisor < 0L) {
            if (LongPtr.compareUnsigned(dividend, divisor) < 0) {
                return 0L;
            }
            return 1L;
        }
        if (dividend >= 0L) {
            return dividend / divisor;
        }
        long rem = dividend - (quotient = (dividend >>> 1) / divisor << 1) * divisor;
        return quotient + (long)(LongPtr.compareUnsigned(rem, divisor) >= 0 ? 1 : 0);
    }

    public static long unsignedRemainder(long dividend, long divisor) {
        if (dividend > 0L && divisor > 0L) {
            return dividend % divisor;
        }
        if (LongPtr.compareUnsigned(dividend, divisor) < 0) {
            return dividend;
        }
        return LongPtr.toUnsignedBigInteger(dividend).remainder(LongPtr.toUnsignedBigInteger(divisor)).longValue();
    }

    private static BigInteger toUnsignedBigInteger(long i) {
        if (i >= 0L) {
            return BigInteger.valueOf(i);
        }
        int upper = (int)(i >>> 32);
        int lower = (int)i;
        return BigInteger.valueOf(LongPtr.toUnsignedLong(upper)).shiftLeft(32).add(BigInteger.valueOf(LongPtr.toUnsignedLong(lower)));
    }

    private static long toUnsignedLong(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    private static long flip(long a) {
        return a ^ Long.MIN_VALUE;
    }

    public static int compareUnsigned(long a, long b) {
        return Long.compare(LongPtr.flip(a), LongPtr.flip(b));
    }

    public static long unsignedMax(long a, long b) {
        if (a == b) {
            return a;
        }
        if (LongPtr.flip(a) > LongPtr.flip(b)) {
            return a;
        }
        return b;
    }

    public static long unsignedMin(long a, long b) {
        if (a == b) {
            return a;
        }
        if (LongPtr.flip(a) < LongPtr.flip(b)) {
            return a;
        }
        return b;
    }
}

