/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.util.Arrays;
import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Ptr;

public class MixedPtr
extends AbstractPtr {
    private static final int POINTER_BYTES = 4;
    private byte[] primitives;
    private Object[] references;
    private int offset = 0;

    private MixedPtr() {
    }

    private MixedPtr(byte[] primitives, Object[] references, int offset) {
        this.primitives = primitives;
        this.references = references;
        this.offset = offset;
    }

    public static MixedPtr malloc(int bytes) {
        MixedPtr ptr = new MixedPtr();
        ptr.primitives = new byte[bytes];
        ptr.references = new Object[MixedPtr.mallocSize(bytes, 4)];
        return ptr;
    }

    @Override
    public Object getArray() {
        return this.primitives;
    }

    @Override
    public int getOffsetInBytes() {
        return this.offset;
    }

    @Override
    public Ptr realloc(int newSizeInBytes) {
        if (newSizeInBytes == this.primitives.length) {
            return this;
        }
        MixedPtr ptr = new MixedPtr();
        ptr.primitives = Arrays.copyOf(this.primitives, newSizeInBytes);
        ptr.references = Arrays.copyOf(this.references, MixedPtr.mallocSize(newSizeInBytes, 4));
        return ptr;
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        if (bytes == 0) {
            return this;
        }
        return new MixedPtr(this.primitives, this.references, this.offset + bytes);
    }

    @Override
    public byte getByte(int offset) {
        return this.primitives[this.offset + offset];
    }

    @Override
    public void setByte(int offset, byte value) {
        this.primitives[this.offset + offset] = value;
    }

    @Override
    public Ptr getPointer(int offset) {
        int index;
        Ptr ref;
        int byteStart = this.offset + offset;
        if (byteStart % 4 == 0 && (ref = (Ptr)this.references[index = byteStart / 4]) != null) {
            return ref;
        }
        return BytePtr.NULL.pointerPlus(this.getInt(offset));
    }

    @Override
    public final void setPointer(int offset, Ptr value) {
        int byteStart = this.offset + offset;
        if (byteStart % 4 != 0) {
            throw new UnsupportedOperationException("Unaligned pointer storage");
        }
        int index = byteStart / 4;
        this.references[index] = value;
        this.setInt(offset, value.toInt());
    }

    @Override
    public int toInt() {
        return this.getOffsetInBytes();
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public void memcpy(Ptr source, int numBytes) {
        if (source instanceof MixedPtr && numBytes % 4 == 0) {
            MixedPtr ptr = (MixedPtr)source;
            System.arraycopy(ptr.primitives, ptr.offset, this.primitives, this.offset, numBytes);
            System.arraycopy(ptr.references, ptr.offset / 4, this.references, this.offset / 4, numBytes / 4);
        } else {
            for (int i = 0; i < numBytes; ++i) {
                this.setByte(i, source.getByte(i));
            }
        }
    }

    @Override
    public Ptr copyOf(int offset, int numBytes) {
        MixedPtr copy2 = new MixedPtr();
        copy2.primitives = Arrays.copyOfRange(this.primitives, this.offset + offset, this.offset + offset + numBytes);
        copy2.references = Arrays.copyOfRange(this.references, (this.offset + offset) / 4, (this.offset + offset + numBytes) / 4);
        return copy2;
    }
}

