/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.reflection.converters;

import java.lang.reflect.Array;
import org.renjin.eval.EvalException;
import org.renjin.invoke.reflection.converters.Converter;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.SEXP;

public class DoubleArrayConverter
implements Converter<Object> {
    public static final DoubleArrayConverter DOUBLE_ARRAY = new DoubleArrayConverter(Double.TYPE);
    protected final Class componentClass;

    protected DoubleArrayConverter(Class clazz) {
        this.componentClass = clazz;
    }

    public boolean accept(Class clazz) {
        return clazz.isArray() && clazz.getComponentType().equals(this.componentClass);
    }

    public final DoubleVector convertToR(Object value) {
        if (value == null) {
            return new DoubleArrayVector(DoubleVector.NA);
        }
        double[] dArray = new double[Array.getLength(value)];
        for (int i = 0; i < Array.getLength(value); ++i) {
            dArray[i] = ((Number)Array.get(value, i)).doubleValue();
        }
        return new DoubleArrayVector(dArray);
    }

    @Override
    public final boolean acceptsSEXP(SEXP exp2) {
        return exp2 instanceof DoubleVector || exp2 instanceof IntVector || exp2 instanceof LogicalVector;
    }

    @Override
    public final int getSpecificity() {
        return 3;
    }

    @Override
    public final Object convertToJava(SEXP value) {
        if (!(value instanceof AtomicVector)) {
            throw new EvalException("It's not an AtomicVector", value.getTypeName());
        }
        return this.convertToJavaArray((AtomicVector)value);
    }

    protected Object convertToJavaArray(AtomicVector vector2) {
        return vector2.toDoubleArray();
    }
}

