/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.methods;

import java.util.HashMap;
import org.renjin.eval.Calls;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.SessionScoped;
import org.renjin.methods.Methods;
import org.renjin.primitives.Evaluation;
import org.renjin.repackaged.guava.base.Preconditions;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.PrimitiveFunction;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

@SessionScoped
public class MethodDispatch {
    public static final Symbol DOT_METHOD = Symbol.get(".Method");
    public static final Symbol DOT_METHODS = Symbol.get(".Methods");
    public static final Symbol DOT_DEFINED = Symbol.get(".defined");
    public static final Symbol DOT_TARGET = Symbol.get(".target");
    public static final Symbol DOT_GENERIC = Symbol.get(".Generic");
    public static final Symbol GENERIC = Symbol.get("generic");
    public static final Symbol R_target = Symbol.get("target");
    public static final Symbol R_defined = Symbol.get("defined");
    public static final Symbol R_nextMethod = Symbol.get("nextMethod");
    public static final Symbol R_loadMethod_name = Symbol.get("loadMethod");
    public static final Symbol R_dot_target = Symbol.get(".target");
    public static final Symbol R_dot_defined = Symbol.get(".defined");
    public static final Symbol R_dot_nextMethod = Symbol.get(".nextMethod");
    public static final Symbol R_dot_Method = Symbol.get(".Method");
    public static final Symbol s_dot_Methods = Symbol.get(".Methods");
    public static final Symbol s_skeleton = Symbol.get("skeleton");
    public static final Symbol s_expression = Symbol.get("expression");
    public static final Symbol s_function = Symbol.get("function");
    public static final Symbol s_getAllMethods = Symbol.get("getAllMethods");
    public static final Symbol s_objectsEnv = Symbol.get("objectsEnv");
    public static final Symbol s_MethodsListSelect = Symbol.get("MethodsListSelect");
    public static final Symbol s_sys_dot_frame = Symbol.get("sys.frame");
    public static final Symbol s_sys_dot_call = Symbol.get("sys.call");
    public static final Symbol s_sys_dot_function = Symbol.get("sys.function");
    public static final Symbol s_generic = Symbol.get("generic");
    public static final Symbol s_generic_dot_skeleton = Symbol.get("generic.skeleton");
    public static final Symbol s_subset_gets = Symbol.get("[<-");
    public static final Symbol s_element_gets = Symbol.get("[[<-");
    public static final Symbol s_argument = Symbol.get("argument");
    public static final Symbol s_allMethods = Symbol.get("allMethods");
    public static final Symbol s_dot_Data = Symbol.get(".Data");
    public static final Symbol s_dot_S3Class = Symbol.get(".S3Class");
    public static final Symbol s_getDataPart = Symbol.get("getDataPart");
    public static final Symbol s_setDataPart = Symbol.get("setDataPart");
    public static final Symbol s_xData = Symbol.get(".xData");
    public static final Symbol s_dotData = Symbol.get(".Data");
    public static final Symbol R_mtable = Symbol.get(".MTable");
    public static final Symbol R_allmtable = Symbol.get(".AllMTable");
    public static final Symbol R_sigargs = Symbol.get(".SigArgs");
    public static final Symbol R_siglength = Symbol.get(".SigLength");
    public static final StringVector s_missing = StringVector.valueOf("missing");
    public static final Symbol pseudo_NULL = Symbol.get("\u0001NULL\u0001");
    private boolean enabled = false;
    private HashMap<String, SEXP> extendsTable = Maps.newHashMap();
    private Environment methodsNamespace;
    private boolean tableDispatchEnabled = true;

    public void init(Environment environment2) {
        this.methodsNamespace = environment2;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public SEXP getExtends(String className) {
        SEXP value = this.extendsTable.get(className);
        if (value == null) {
            return Null.INSTANCE;
        }
        return value;
    }

    public void putExtends(String className, SEXP klass) {
        this.extendsTable.put(className, klass);
    }

    public Environment getMethodsNamespace() {
        Preconditions.checkState(this.methodsNamespace != null, "methods namespace is not loaded.");
        return this.methodsNamespace;
    }

    public SEXP standardGeneric(Context context, Symbol fname, Environment ev, SEXP fdef) {
        if (this.tableDispatchEnabled) {
            return this.R_dispatchGeneric(context, fname, ev, fdef);
        }
        throw new UnsupportedOperationException();
    }

    public SEXP R_dispatchGeneric(Context context, Symbol fname, Environment ev, SEXP fdef) {
        SEXP f;
        Environment f_env;
        SEXP val = Null.INSTANCE;
        boolean lwidth = false;
        boolean prim_case = false;
        if (fdef instanceof Closure) {
            f_env = ((Closure)fdef).getEnclosingEnvironment();
        } else if (fdef instanceof PrimitiveFunction) {
            if (!((fdef = MethodDispatch.R_primitive_generic(fdef)) instanceof Closure)) {
                throw new EvalException("Failed to get the generic for the primitive \"%s\"", fname.asString());
            }
            f_env = ((Closure)fdef).getEnclosingEnvironment();
            prim_case = true;
        } else {
            throw new EvalException("Expected a generic function or a primitive for dispatch, got an object of class \"%s\"", fdef.getImplicitClass());
        }
        SEXP mtable = f_env.getVariable(context, R_allmtable);
        if (mtable == Symbol.UNBOUND_VALUE) {
            MethodDispatch.do_mtable(fdef, ev);
            mtable = f_env.getVariable(context, R_allmtable);
        }
        SEXP sigargs = f_env.getVariable(context, R_sigargs);
        SEXP siglength = f_env.getVariable(context, R_siglength);
        if (sigargs == Symbol.UNBOUND_VALUE || siglength == Symbol.UNBOUND_VALUE || mtable == Symbol.UNBOUND_VALUE) {
            throw new EvalException("Generic \"%s\" seems not to have been initialized for table dispatch---need to have .SigArgs and .AllMtable assigned in its environment", fname.asString());
        }
        int nargs2 = (int)siglength.asReal();
        ListVector.Builder classListBuilder = ListVector.newBuilder();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < nargs2; ++i) {
            StringVector thisClass;
            Symbol arg_sym = (Symbol)sigargs.getElementAsSEXP(i);
            if (MethodDispatch.is_missing_arg(context, arg_sym, ev)) {
                thisClass = s_missing;
            } else {
                SEXP arg;
                try {
                    arg = context.evaluate(arg_sym, ev);
                }
                catch (EvalException e) {
                    throw new EvalException(String.format("error in evaluating the argument '%s' in selecting a method for function '%s'", arg_sym.getPrintName(), fname.asString()), e);
                }
                thisClass = Methods.R_data_class(arg, true);
            }
            classListBuilder.set(i, thisClass);
            if (i > 0) {
                buf.append("#");
            }
            buf.append(thisClass.asString());
        }
        ListVector classes = classListBuilder.build();
        SEXP method = ((Environment)mtable).getVariable(context, buf.toString());
        if (method == Symbol.UNBOUND_VALUE) {
            method = this.do_inherited_table(context, classes, fdef, mtable, ev);
        }
        if ((f = method).isObject()) {
            f = MethodDispatch.R_loadMethod(context, f, fname.getPrintName(), ev);
        }
        if (!(f instanceof Closure)) {
            if (f instanceof PrimitiveFunction) {
                throw new UnsupportedOperationException();
            }
            throw new EvalException("invalid object (non-function) used as method", new Object[0]);
        }
        val = MethodDispatch.R_execMethod(context, (Closure)f, ev);
        return val;
    }

    public SEXP R_standardGeneric(Context context, Symbol fsym, Environment ev, SEXP fdef) {
        String fname = fsym.getPrintName();
        Environment f_env = context.getBaseEnvironment();
        SEXP mlist = Null.INSTANCE;
        Null val = Null.INSTANCE;
        boolean nprotect = false;
        if (fdef instanceof Closure) {
            f_env = ((Closure)fdef).getEnclosingEnvironment();
            mlist = f_env.getVariable(context, ".Methods");
            if (mlist == Symbol.UNBOUND_VALUE) {
                mlist = Null.INSTANCE;
            }
        } else {
            if (fdef instanceof PrimitiveFunction) {
                f_env = context.getBaseEnvironment();
                throw new UnsupportedOperationException();
            }
            throw new EvalException("invalid generic function object for method selection for function '%s': expected a function or a primitive, got an object of class \"%s\"", fsym.getPrintName(), fdef.getAttributes().getClassVector());
        }
        if (!(mlist instanceof Null || mlist instanceof Closure || mlist instanceof PrimitiveFunction)) {
            throw new UnsupportedOperationException();
        }
        SEXP f = mlist;
        if (f == Null.INSTANCE) {
            SEXP value = this.R_S_MethodsListSelect(context, StringArrayVector.valueOf(fname), ev, mlist, f_env);
            if (value == Null.INSTANCE) {
                throw new EvalException("no direct or inherited method for function '%s' for this call", fname);
            }
            mlist = value;
            f = this.do_dispatch(context, fname, ev, mlist, false, true);
        }
        if (f.isObject()) {
            f = MethodDispatch.R_loadMethod(context, f, fsym.getPrintName(), ev);
        }
        if (f instanceof Closure) {
            return MethodDispatch.R_execMethod(context, (Closure)f, ev);
        }
        if (f instanceof PrimitiveFunction) {
            throw new UnsupportedOperationException();
        }
        throw new EvalException("invalid object (non-function) used as method", new Object[0]);
    }

    private SEXP R_S_MethodsListSelect(Context context, SEXP fname, SEXP ev, SEXP mlist, SEXP f_env) {
        PairList.Builder args2 = new PairList.Builder();
        args2.add(fname);
        args2.add(ev);
        args2.add(mlist);
        if (f_env != Null.INSTANCE) {
            args2.add(f_env);
        }
        try {
            return context.evaluate(new FunctionCall(s_MethodsListSelect, args2.build()), this.methodsNamespace);
        }
        catch (EvalException e) {
            throw new EvalException(String.format("S language method selection got an error when called from internal dispatch for function '%s'", fname), e);
        }
    }

    private static SEXP R_loadMethod(Context context, SEXP def, String fname, Environment ev) {
        int found = 1;
        PairList attrib = def.getAttributes().asPairList();
        for (PairList.Node s : attrib.nodes()) {
            Symbol t2 = s.getTag();
            if (t2 == R_target) {
                ev.setVariable(context, R_dot_target, s.getValue());
                ++found;
                continue;
            }
            if (t2 == R_defined) {
                ev.setVariable(context, R_dot_defined, s.getValue());
                ++found;
                continue;
            }
            if (t2 == R_nextMethod) {
                ev.setVariable(context, R_dot_nextMethod, s.getValue());
                ++found;
                continue;
            }
            if (t2 != Symbols.SOURCE) continue;
            ++found;
        }
        ev.setVariable(context, R_dot_Method, def);
        if (fname.equals("loadMethod")) {
            return def;
        }
        if (found < attrib.length()) {
            FunctionCall call2 = FunctionCall.newCall(R_loadMethod_name, def, StringArrayVector.valueOf(fname), ev);
            return context.evaluate(call2, ev);
        }
        return def;
    }

    private SEXP do_dispatch(Context context, String fname, SEXP ev, SEXP mlist, boolean firstTry, boolean evalArgs) {
        String klass;
        Null value = Null.INSTANCE;
        boolean nprotect = false;
        if (mlist instanceof Function) {
            return mlist;
        }
        SEXP arg_slot = Methods.R_do_slot(context, mlist, s_argument);
        if (arg_slot == Null.INSTANCE) {
            throw new EvalException("object of class \"%s\" used as methods list for function '%s' ( no 'argument' slot)", mlist.toString(), fname);
        }
        Symbol arg_sym = arg_slot instanceof Symbol ? (Symbol)arg_slot : Symbol.get(arg_slot.asString());
        if (evalArgs) {
            if (MethodDispatch.is_missing_arg(context, arg_sym, (Environment)ev)) {
                klass = "missing";
            } else {
                SEXP arg;
                try {
                    arg = context.evaluate(arg_sym, (Environment)ev);
                }
                catch (EvalException e) {
                    throw new EvalException(String.format("error in evaluating the argument '%s' in selecting a method for function '%s'", arg_sym.getPrintName(), fname), e);
                }
                StringVector class_obj = Methods.R_data_class(arg, true);
                klass = class_obj.asString();
            }
        } else {
            SEXP arg;
            try {
                arg = context.evaluate(arg_sym, (Environment)ev);
            }
            catch (Exception e) {
                throw new EvalException(String.format("error in evaluating the argument '%s' in selecting a method for function '%s'", arg_sym.getPrintName(), fname), new Object[0]);
            }
            klass = arg.asString();
        }
        SEXP method = this.R_find_method(mlist, klass, fname);
        if (method == Null.INSTANCE && !firstTry) {
            throw new EvalException("no matching method for function '%s' (argument '%s', with class \"%s\")", fname, arg_sym.getPrintName(), klass);
        }
        if (value == Symbol.MISSING_ARG) {
            throw new EvalException("recursive use of function '%s' in method selection, with no default method", fname);
        }
        if (!(method instanceof Function)) {
            method = this.do_dispatch(context, null, ev, method, firstTry, evalArgs);
        }
        return method;
    }

    private SEXP R_find_method(SEXP mlist, String klass, String fname) {
        throw new UnsupportedOperationException();
    }

    private static SEXP R_primitive_generic(SEXP fdef) {
        throw new UnsupportedOperationException();
    }

    private static SEXP do_inherited_table(StringVector classes, SEXP fdef, SEXP mtable, Environment ev) {
        throw new UnsupportedOperationException();
    }

    private static void do_mtable(SEXP fdef, Environment ev) {
        throw new UnsupportedOperationException();
    }

    private static boolean is_missing_arg(Context context, Symbol arg_sym, Environment ev) {
        return Evaluation.missing(context, ev, arg_sym);
    }

    public static SEXP R_execMethod(Context context, Closure op, Environment rho) {
        Environment.Builder newrho = Environment.createChildEnvironment(op.getEnclosingEnvironment());
        for (PairList.Node next : op.getFormals().nodes()) {
            if (!next.hasTag()) {
                throw new EvalException("closure formal has no tag! op = " + op, new Object[0]);
            }
            Symbol symbol2 = next.getTag();
            SEXP val = rho.findVariable(context, symbol2);
            if (val == Symbol.UNBOUND_VALUE) {
                throw new EvalException("could not find symbol \"%s\" in the environment of the generic function", symbol2.getPrintName());
            }
            newrho.setVariable(symbol2, val);
        }
        newrho.setVariable(DOT_DEFINED, rho.findVariableOrThrow(context, DOT_DEFINED));
        newrho.setVariable(DOT_METHOD, rho.findVariableOrThrow(context, DOT_METHOD));
        newrho.setVariable(DOT_TARGET, rho.findVariableOrThrow(context, DOT_TARGET));
        newrho.setVariable(DOT_GENERIC, rho.findVariableOrThrow(context, DOT_GENERIC));
        newrho.setVariable(DOT_METHODS, rho.findVariableOrThrow(context, DOT_METHODS));
        Context cptr = context;
        Environment callerenv = cptr.getCallingEnvironment();
        FunctionCall call2 = cptr.getCall();
        PairList arglist = cptr.getArguments();
        SEXP val = MethodDispatch.R_execClosure(context, call2, op, arglist, callerenv, newrho.build());
        return val;
    }

    private static SEXP R_execClosure(Context context, FunctionCall call2, Closure op, PairList arglist, Environment callerenv, Environment newrho) {
        return Calls.applyClosure(op, context, callerenv, call2, arglist, newrho.getFrame());
    }

    private SEXP do_inherited_table(Context context, SEXP class_objs, SEXP fdef, SEXP mtable, Environment ev) {
        Function fun = this.methodsNamespace.findFunction(context, Symbol.get(".InheritForDispatch"));
        return context.evaluate(FunctionCall.newCall(fun, class_objs, fdef, mtable), ev);
    }
}

