/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.dnorm;
import org.renjin.nmath.dpois;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.lgamma;
import org.renjin.nmath.pnorm;

public class pgamma {
    public static double M_cutoff;
    public static double scalefactor;
    public static double[] $ppois_asymp$coefs_b;
    public static double[] $ppois_asymp$coefs_a;
    public static double[] $lgamma1p$coeffs;
    public static double $log1pmx$tol_logcf;
    public static double $log1pmx$two;
    public static double $log1pmx$minLog1Value;

    static {
        $ppois_asymp$coefs_b = new double[8];
        $ppois_asymp$coefs_a = new double[8];
        $lgamma1p$coeffs = new double[40];
        M_cutoff = 3.196577161300664E18;
        scalefactor = 1.157920892373162E77;
        double[] dArray = new double[]{-1.0E99, 0.08333333333333333, 0.003472222222222222, -0.0026813271604938273, -2.2947209362139917E-4, 7.840392217200666E-4, 6.972813758365857E-5, -5.921664373536939E-4};
        System.arraycopy(dArray, 0, $ppois_asymp$coefs_b, 0, 8);
        dArray = new double[]{-1.0E99, 0.6666666666666666, -0.02962962962962963, 0.0028218694885361554, 0.0018812463256907702, -7.119598889146215E-4, -6.783725850941215E-4, 4.728641948577934E-4};
        System.arraycopy(dArray, 0, $ppois_asymp$coefs_a, 0, 8);
        dArray = new double[]{0.3224670334241132, 0.0673523010531981, 0.020580808427784546, 0.007385551028673986, 0.0028905103307415234, 0.001192753911703261, 5.096695247430425E-4, 2.2315475845357939E-4, 9.945751278180853E-5, 4.492623673813314E-5, 2.050721277567069E-5, 9.439488275268397E-6, 4.374866789907488E-6, 2.039215753801366E-6, 9.55141213040742E-7, 4.492469198764566E-7, 2.1207184805554665E-7, 1.0043224823968099E-7, 4.7698101693639804E-8, 2.2711094608943164E-8, 1.0838659214896955E-8, 5.183475041970047E-9, 2.4836745438024785E-9, 1.1921401405860912E-9, 5.731367241678862E-10, 2.7595228851242334E-10, 1.330476437424449E-10, 6.4229645638381E-11, 3.1044247747322276E-11, 1.5021384080754142E-11, 7.275974480239079E-12, 3.527742476575915E-12, 1.711991790559618E-12, 8.315385841420285E-13, 4.04220052528944E-13, 1.9664756310966165E-13, 9.573630387838556E-14, 4.6640760264283744E-14, 2.2737369600659724E-14, 1.1091399470834522E-14};
        System.arraycopy(dArray, 0, $lgamma1p$coeffs, 0, 40);
        $log1pmx$tol_logcf = 1.0E-14;
        $log1pmx$two = 2.0;
        $log1pmx$minLog1Value = -0.79149064;
    }

    private pgamma() {
    }

    public static double Rf_pgamma_raw(double d, double d2, int n, int n2) {
        if (d <= 0.0) {
            d = n != 0 ? (n2 != 0 ? Double.NEGATIVE_INFINITY : 0.0) : (n2 != 0 ? 0.0 : 1.0);
        } else if (d >= Double.POSITIVE_INFINITY) {
            d = n != 0 ? (n2 != 0 ? 0.0 : 1.0) : (n2 != 0 ? Double.NEGATIVE_INFINITY : 0.0);
        } else {
            double d3;
            if (d < 1.0) {
                d3 = pgamma.pgamma_smallx(d, d2, n, n2);
            } else if (d2 - 1.0 >= d && (d2 + 50.0) * 0.8 > d) {
                double d4 = pgamma.pd_upper_series(d, d2, n2);
                d3 = pgamma.dpois_wrap(d2, d, n2);
                d3 = n == 0 ? (n2 != 0 ? (d3 + d4 > -0.6931471805599453 ? Math.log(-Mathlib.expm1(d3 + d4)) : Mathlib.log1p(-Math.exp(d3 + d4))) : 1.0 - d3 * d4) : (n2 != 0 ? d4 + d3 : d4 * d3);
            } else if (d2 - 1.0 < d && (d + 50.0) * 0.8 > d2) {
                double d5;
                d3 = pgamma.dpois_wrap(d2, d, n2);
                if (d2 < 1.0) {
                    if (d * 2.220446049250313E-16 > 1.0 - d2) {
                        d5 = n2 != 0 ? 0.0 : 1.0;
                    } else {
                        d5 = pgamma.pd_lower_cf(d2, d - (d2 - 1.0)) * d / d2;
                        if (n2 != 0) {
                            d5 = Math.log(d5);
                        }
                    }
                } else {
                    d5 = pgamma.pd_lower_series(d, d2 - 1.0);
                    d5 = n2 != 0 ? Mathlib.log1p(d5) : (d5 += 1.0);
                }
                d3 = n == 0 ? (n2 != 0 ? d5 + d3 : d5 * d3) : (n2 != 0 ? (d3 + d5 > -0.6931471805599453 ? Math.log(-Mathlib.expm1(d3 + d5)) : Mathlib.log1p(-Math.exp(d3 + d5))) : 1.0 - d3 * d5);
            } else {
                int n3 = n != 0 ? 0 : 1;
                d3 = pgamma.ppois_asymp(d2 - 1.0, d, n3, n2);
            }
            d = n2 == 0 && d3 < 1.0020841800044864E-292 ? Math.exp(pgamma.Rf_pgamma_raw(d, d2, n, 1)) : d3;
        }
        return d;
    }

    public static double dpnorm(double d, int n, double d2) {
        if (d < 0.0) {
            d = -d;
            n = n != 0 ? 0 : 1;
        }
        if (d > 10.0 && n == 0) {
            double d3 = d2 = 1.0 / d;
            d *= d;
            double d4 = 1.0;
            do {
                d2 = -d4 / d * d2;
                d4 += 2.0;
            } while (Math.abs(d2) > (d3 += d2) * 2.220446049250313E-16);
            d = 1.0 / d3;
        } else {
            d = dnorm.dnorm4(d, 0.0, 1.0, 0) / Math.exp(d2);
        }
        return d;
    }

    public static double dpois_wrap(double d, double d2, int n) {
        if (Builtins.__finite(d2) == 0) {
            d = n != 0 ? Double.NEGATIVE_INFINITY : 0.0;
        } else if (d > 1.0) {
            d = dpois.dpois_raw(d - 1.0, d2, n);
        } else if (Math.abs(d - 1.0) * M_cutoff < d2) {
            d = n != 0 ? -d2 - lgamma.lgammafn(d) : Math.exp(-d2 - lgamma.lgammafn(d));
        } else {
            double d3 = dpois.dpois_raw(d, d2, n);
            d = n != 0 ? Math.log(d / d2) + d3 : d / d2 * d3;
        }
        return d;
    }

    public static double lgamma1p(double d) {
        if (Math.abs(d) >= 0.5) {
            d = lgamma.lgammafn(d + 1.0);
        } else {
            double d2 = pgamma.logcf(-d / 2.0, 42, 1.0, 1.0E-14) * 2.2737368458246524E-13;
            int n = 39;
            while (n >= 0) {
                d2 = $lgamma1p$coeffs[n] - d * d2;
                --n;
            }
            d = (d * d2 - 0.5772156649015329) * d - pgamma.log1pmx(d);
        }
        return d;
    }

    public static double log1pmx(double d) {
        if (d > 1.0 || d < $log1pmx$minLog1Value) {
            d = Mathlib.log1p(d) - d;
        } else {
            double d2 = d / (d + 2.0);
            double d3 = d2 * d2;
            d = Math.abs(d) < 0.01 ? (((($log1pmx$two / 9.0 * d3 + $log1pmx$two / 7.0) * d3 + $log1pmx$two / 5.0) * d3 + $log1pmx$two / 3.0) * d3 - d) * d2 : (d3 * 2.0 * pgamma.logcf(d3, 3.0, 2.0, $log1pmx$tol_logcf) - d) * d2;
        }
        return d;
    }

    public static double logcf(double d, double d2, double d3, double d4) {
        double d5 = d3 * 2.0;
        double d6 = d2 + d3;
        double d7 = d6 + d3;
        double d8 = d6;
        double d9 = (d6 - d2 * d) * d2;
        double d10 = d3 * d3 * d;
        double d11 = d7 * d6 - d10;
        d2 = d7 * d9 - d10 * d2;
        while (Math.abs(d11 * d9 - d8 * d2) > Math.abs(d4 * d9 * d2)) {
            double d12 = d6 * d6 * d;
            d6 += d3;
            d8 = d12 * d8;
            d8 = (d7 += d3) * d11 - d8;
            d9 = d12 * d9;
            d9 = d7 * d2 - d9;
            double d13 = d5 * d5 * d;
            d5 += d3;
            d11 = d13 * d11;
            d11 = (d7 += d3) * d8 - d11;
            d2 = d13 * d2;
            if (Math.abs(d2 = d7 * d9 - d2) > scalefactor) {
                d8 /= scalefactor;
                d9 /= scalefactor;
                d11 /= scalefactor;
                d2 /= scalefactor;
                continue;
            }
            if (!(Math.abs(d2) < 1.0 / scalefactor)) continue;
            d8 *= scalefactor;
            d9 *= scalefactor;
            d11 *= scalefactor;
            d2 *= scalefactor;
        }
        return d11 / d2;
    }

    public static double logspace_add(double d, double d2) {
        return fmax2.fmax2(d, d2) + Mathlib.log1p(Math.exp(-Math.abs(d - d2)));
    }

    public static double logspace_sub(double d, double d2) {
        d2 = d2 - d > -0.6931471805599453 ? Math.log(-Mathlib.expm1(d2 - d)) : Mathlib.log1p(-Math.exp(d2 - d));
        return d2 + d;
    }

    public static double logspace_sum(Ptr ptr, int n) {
        double d;
        if (n == 0) {
            d = Double.NEGATIVE_INFINITY;
        } else if (n == 1) {
            d = ptr.getDouble();
        } else if (n == 2) {
            d = ptr.getDouble(8);
            d = pgamma.logspace_add(ptr.getDouble(), d);
        } else {
            d = ptr.getDouble();
            int n2 = 1;
            while (n2 < n) {
                if (ptr.getDouble(n2 * 8) > d) {
                    d = ptr.getDouble(n2 * 8);
                }
                ++n2;
            }
            double d2 = 0.0;
            n2 = 0;
            while (n2 < n) {
                d2 = Math.exp(ptr.getDouble(n2 * 8) - d) + d2;
                ++n2;
            }
            d = Math.log(d2) + d;
        }
        return d;
    }

    public static double pd_lower_cf(double d, double d2) {
        block9: {
            double d3 = 0.0;
            if (d == 0.0) {
                d = 0.0;
            } else {
                double d4 = d / d2;
                if (Math.abs(d - 1.0) < Math.abs(d2) * 2.220446049250313E-16) {
                    d = d4;
                } else {
                    if (d4 > 1.0) {
                        d4 = 1.0;
                    }
                    double d5 = d;
                    double d6 = d2;
                    double d7 = 0.0;
                    double d8 = 1.0;
                    while (d2 > scalefactor) {
                        d7 /= scalefactor;
                        d8 /= scalefactor;
                        d /= scalefactor;
                        d2 /= scalefactor;
                    }
                    double d9 = 0.0;
                    double d10 = -1.0;
                    while (d9 < 200000.0) {
                        double d11 = d9 + 1.0;
                        double d12 = d11 * (d5 -= 1.0);
                        d7 = d12 * d7 + (d6 += 2.0) * d;
                        d8 = d12 * d8 + d6 * d2;
                        d9 = d11 + 1.0;
                        double d13 = d9 * (d5 -= 1.0);
                        d = d13 * d + (d6 += 2.0) * d7;
                        if ((d2 = d13 * d2 + d6 * d8) > scalefactor) {
                            d7 /= scalefactor;
                            d8 /= scalefactor;
                            d /= scalefactor;
                            d2 /= scalefactor;
                        }
                        if (d2 == 0.0) continue;
                        d3 = d / d2;
                        if (Math.abs(d3 - d10) <= fmax2.fmax2(d4, Math.abs(d3)) * 2.220446049250313E-16) {
                            d = d3;
                            break block9;
                        }
                        d10 = d3;
                    }
                    Stdlib.printf(new BytePtr(" ** NON-convergence in pgamma()'s pd_lower_cf() f= %g.\n\u0000".getBytes(), 0), d3);
                    d = d3;
                }
            }
        }
        return d;
    }

    public static double pd_lower_series(double d, double d2) {
        double d3 = 1.0;
        double d4 = 0.0;
        while (d2 >= 1.0 && d4 * 2.220446049250313E-16 < d3) {
            d3 = d2 / d * d3;
            d4 += d3;
            d2 -= 1.0;
        }
        if (Mathlib.floor(d2) != d2) {
            d4 = d3 * pgamma.pd_lower_cf(d2, d + 1.0 - d2) + d4;
        }
        return d4;
    }

    public static double pd_upper_series(double d, double d2, int n) {
        double d3;
        double d4 = d3 = d / d2;
        while ((d4 += (d3 = d / (d2 += 1.0) * d3)) * 2.220446049250313E-16 < d3) {
        }
        d = n != 0 ? Math.log(d4) : d4;
        return d;
    }

    public static double pgamma(double d, double d2, double d3, int n, int n2) {
        if (Builtins.__isnan(d) != 0 || Builtins.__isnan(d2) != 0 || Builtins.__isnan(d3) != 0) {
            d = d + d2 + d3;
        } else if (d2 < 0.0 || d3 <= 0.0) {
            d = Double.NaN;
        } else if (Builtins.__isnan(d /= d3) != 0) {
        } else {
            d = d2 == 0.0 ? (d <= 0.0 ? (n != 0 ? (n2 != 0 ? Double.NEGATIVE_INFINITY : 0.0) : (n2 != 0 ? 0.0 : 1.0)) : (n != 0 ? (n2 != 0 ? 0.0 : 1.0) : (n2 != 0 ? Double.NEGATIVE_INFINITY : 0.0))) : pgamma.Rf_pgamma_raw(d, d2, n, n2);
        }
        return d;
    }

    public static double pgamma_smallx(double d, double d2, int n, int n2) {
        double d3;
        double d4 = 0.0;
        double d5 = d2;
        double d6 = 0.0;
        while (Math.abs(d3 = (d5 = -d / (d6 += 1.0) * d5) / (d2 + d6)) > Math.abs(d4 += d3) * 2.220446049250313E-16) {
        }
        if (n != 0) {
            d4 = n2 != 0 ? Mathlib.log1p(d4) : (d4 += 1.0);
            if (d2 > 1.0) {
                d2 = dpois.dpois_raw(d2, d, n2);
                d = n2 != 0 ? d2 + d : Math.exp(d) * d2;
            } else {
                d = n2 != 0 ? Math.log(d) * d2 - pgamma.lgamma1p(d2) : Mathlib.pow(d, d2) / Math.exp(pgamma.lgamma1p(d2));
            }
            d = n2 != 0 ? d4 + d : d4 * d;
        } else {
            d = Math.log(d) * d2 - pgamma.lgamma1p(d2);
            if (n2 != 0) {
                d = Mathlib.log1p(d4) + d > -0.6931471805599453 ? Math.log(-Mathlib.expm1(Mathlib.log1p(d4) + d)) : Mathlib.log1p(-Math.exp(Mathlib.log1p(d4) + d));
            } else {
                d = Mathlib.expm1(d);
                d2 = d4 + d;
                d = -(d4 * d + d2);
            }
        }
        return d;
    }

    public static double ppois_asymp(double d, double d2, int n, int n2) {
        double d3;
        double d4 = d2 - d;
        double d5 = -pgamma.log1pmx(d4 / d);
        d2 = Mathlib.sqrt(d * 2.0 * d5);
        if (d4 < 0.0) {
            d2 = -d2;
        }
        double d6 = 0.0;
        double d7 = d3 = Mathlib.sqrt(d);
        double d8 = d2;
        double d9 = d2;
        int n3 = 1;
        while (n3 <= 7) {
            d6 = $ppois_asymp$coefs_a[n3] * d7 + d6 + $ppois_asymp$coefs_b[n3] * d9;
            d3 = d5 / (double)n3 * d3;
            d8 = d5 * 2.0 / (double)(n3 * 2 + 1) * d8;
            d7 = d7 / d + d3;
            d9 = d9 / d + d8;
            ++n3;
        }
        d5 = d;
        d3 = 1.0;
        n3 = 1;
        while (n3 <= 7) {
            d5 = $ppois_asymp$coefs_b[n3] * d3 + d5;
            d3 /= d;
            ++n3;
        }
        if (n == 0) {
            d5 = -d5;
        }
        d6 /= d5;
        n3 = n != 0 ? 0 : 1;
        d = pnorm.pnorm5(d2, 0.0, 1.0, n3, n2);
        if (n2 != 0) {
            n = n != 0 ? 0 : 1;
            d = Mathlib.log1p(d6 * pgamma.dpnorm(d2, n, d)) + d;
        } else {
            d = d6 * dnorm.dnorm4(d2, 0.0, 1.0, n2) + d;
        }
        return d;
    }
}

