/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.pipeliner;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.renjin.eval.EvalException;
import org.renjin.pipeliner.DeferredGraph;
import org.renjin.pipeliner.node.DataNode;
import org.renjin.pipeliner.node.DeferredNode;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.repackaged.guava.collect.Sets;

public class DeferredGraphEval {
    private DeferredGraph graph;
    private ExecutorCompletionService<DeferredNode> service;
    private Set<DeferredNode> scheduled = Sets.newIdentityHashSet();
    private Map<DeferredNode, Future<DeferredNode>> submitted = Maps.newIdentityHashMap();
    private int pendingCount = 0;

    public DeferredGraphEval(DeferredGraph graph, ExecutorService service) {
        this.graph = graph;
        this.service = new ExecutorCompletionService(service);
    }

    public void execute() {
        this.scheduleRoots();
        while (this.pendingCount > 0) {
            DeferredNode completed = this.nextCompleted();
            this.submitDependents(completed);
        }
    }

    private DeferredNode nextCompleted() {
        DeferredNode completed;
        try {
            completed = this.service.take().get();
            --this.pendingCount;
        }
        catch (InterruptedException e) {
            throw new EvalException("Deferred vector execution interrupted.", new Object[0]);
        }
        catch (ExecutionException e) {
            throw new EvalException(e.getCause());
        }
        return completed;
    }

    private void submitDependents(DeferredNode completed) {
        for (DeferredNode dependentNode : completed.getUses()) {
            if (this.submitted.containsKey(dependentNode) || !this.inputsComplete(dependentNode)) continue;
            if (dependentNode instanceof Runnable) {
                this.submit(dependentNode);
                continue;
            }
            this.submitDependents(dependentNode);
        }
    }

    private void scheduleRoots() {
        for (DeferredNode node : this.graph.getRoots()) {
            if (!(node instanceof Runnable)) continue;
            this.schedule(node);
        }
    }

    private void schedule(DeferredNode node) {
        boolean ready = true;
        for (DeferredNode input : node.getOperands()) {
            if (!this.needsComputing(input)) continue;
            this.schedule(input);
            ready = false;
        }
        if (ready) {
            this.submit(node);
        }
    }

    private boolean needsComputing(DeferredNode input) {
        return !(input instanceof DataNode);
    }

    private boolean inputsComplete(DeferredNode node) {
        for (DeferredNode input : node.getOperands()) {
            Future<DeferredNode> future;
            if (!(input instanceof Runnable) || (future = this.submitted.get(input)) != null && future.isDone()) continue;
            return false;
        }
        return true;
    }

    private void submit(DeferredNode node) {
        Future<DeferredNode> future = this.service.submit((Runnable)((Object)node), node);
        this.submitted.put(node, future);
        ++this.pendingCount;
    }
}

