/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.pipeliner.fusion;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.renjin.pipeliner.fusion.LoopKernelCompiler;
import org.renjin.pipeliner.fusion.kernel.CompiledKernel;
import org.renjin.pipeliner.fusion.kernel.LoopKernel;
import org.renjin.pipeliner.fusion.node.LoopNode;
import org.renjin.repackaged.guava.cache.Cache;
import org.renjin.repackaged.guava.cache.CacheBuilder;

public class LoopKernelCache {
    private final Cache<String, Future<CompiledKernel>> cache;
    private ExecutorService executorService;

    public LoopKernelCache(ExecutorService executorService) {
        this.executorService = executorService;
        this.cache = CacheBuilder.newBuilder().softValues().maximumSize(100L).build();
    }

    public Future<CompiledKernel> get(LoopKernel kernel, LoopNode[] kernelOperands) {
        String key = this.kernelKey(kernel, kernelOperands);
        Future<CompiledKernel> compiledKernel = this.cache.getIfPresent(key);
        if (compiledKernel == null) {
            LoopKernelCompiler compiler = new LoopKernelCompiler(kernel, kernelOperands);
            compiledKernel = this.executorService.submit(compiler);
            this.cache.put(key, compiledKernel);
        }
        return compiledKernel;
    }

    private String kernelKey(LoopKernel kernel, LoopNode[] kernelOperands) {
        StringBuilder key = new StringBuilder();
        kernel.appendToKey(key);
        key.append(':');
        for (LoopNode kernelOperand : kernelOperands) {
            kernelOperand.appendToKey(key);
        }
        return key.toString();
    }
}

