/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.pipeliner.fusion.kernel;

import org.renjin.pipeliner.ComputeMethod;
import org.renjin.pipeliner.fusion.kernel.LoopKernel;
import org.renjin.pipeliner.fusion.node.LoopNode;
import org.renjin.repackaged.asm.Label;
import org.renjin.repackaged.asm.MethodVisitor;

public class SumMeanKernel
implements LoopKernel {
    private boolean mean;

    private SumMeanKernel(boolean mean2) {
        this.mean = mean2;
    }

    public static SumMeanKernel mean() {
        return new SumMeanKernel(true);
    }

    public static SumMeanKernel sum() {
        return new SumMeanKernel(false);
    }

    @Override
    public void compute(ComputeMethod method, LoopNode[] operands) {
        MethodVisitor mv = method.getVisitor();
        LoopNode vector2 = operands[0];
        vector2.init(method);
        int lengthLocal = method.reserveLocal(1);
        vector2.pushLength(method);
        mv.visitVarInsn(54, lengthLocal);
        int sumLocal = method.reserveLocal(2);
        mv.visitInsn(14);
        mv.visitVarInsn(57, sumLocal);
        int counterLocal = method.reserveLocal(1);
        mv.visitInsn(3);
        mv.visitVarInsn(54, counterLocal);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitVarInsn(21, counterLocal);
        mv.visitVarInsn(21, lengthLocal);
        Label l4 = new Label();
        mv.visitJumpInsn(159, l4);
        Label l5 = new Label();
        mv.visitLabel(l5);
        mv.visitVarInsn(24, sumLocal);
        mv.visitVarInsn(21, counterLocal);
        vector2.pushElementAsDouble(method);
        mv.visitInsn(99);
        mv.visitVarInsn(57, sumLocal);
        Label l6 = new Label();
        mv.visitLabel(l6);
        mv.visitIincInsn(counterLocal, 1);
        mv.visitJumpInsn(167, l3);
        mv.visitLabel(l4);
        mv.visitInsn(4);
        mv.visitIntInsn(188, 7);
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitVarInsn(24, sumLocal);
        if (this.mean) {
            mv.visitVarInsn(21, lengthLocal);
            mv.visitInsn(135);
            mv.visitInsn(111);
        }
        mv.visitInsn(82);
        mv.visitInsn(176);
    }

    @Override
    public String debugLabel(LoopNode[] operands) {
        return (this.mean ? "mean" : "sum") + "(...)";
    }

    @Override
    public void appendToKey(StringBuilder key) {
        key.append(this.mean ? "mean" : "sum");
    }
}

