/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.pipeliner.fusion.node;

import org.renjin.pipeliner.ComputeMethod;
import org.renjin.pipeliner.fusion.node.LoopNode;
import org.renjin.repackaged.asm.Label;
import org.renjin.repackaged.asm.MethodVisitor;
import org.renjin.repackaged.guava.base.Optional;

public class IntBufferNode
extends LoopNode {
    private int operandIndex;
    private int bufferLocal;
    private int bufferLengthLocal;

    public IntBufferNode(int operandIndex) {
        this.operandIndex = operandIndex;
    }

    @Override
    public void init(ComputeMethod method) {
        this.bufferLocal = method.reserveLocal(1);
        this.bufferLengthLocal = method.reserveLocal(1);
        MethodVisitor mv = method.getVisitor();
        mv.visitVarInsn(25, method.getOperandsLocalIndex());
        this.pushIntConstant(mv, this.operandIndex);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, "org/renjin/sexp/IntBufferVector");
        mv.visitMethodInsn(182, "org/renjin/sexp/IntBufferVector", "toIntBufferUnsafe", "()Ljava/nio/IntBuffer;", false);
        mv.visitInsn(89);
        mv.visitVarInsn(58, this.bufferLocal);
        mv.visitMethodInsn(182, "java/nio/IntBuffer", "remaining", "()I", false);
        mv.visitVarInsn(54, this.bufferLengthLocal);
    }

    @Override
    public void pushLength(ComputeMethod method) {
        MethodVisitor mv = method.getVisitor();
        mv.visitVarInsn(21, this.bufferLengthLocal);
    }

    @Override
    public void pushElementAsDouble(ComputeMethod method, Optional<Label> integerNaLabel) {
        this.pushElementAsInt(method, integerNaLabel);
        MethodVisitor mv = method.getVisitor();
        mv.visitInsn(135);
    }

    @Override
    public void pushElementAsInt(ComputeMethod method, Optional<Label> naLabel) {
        MethodVisitor mv = method.getVisitor();
        mv.visitVarInsn(25, this.bufferLocal);
        mv.visitInsn(95);
        mv.visitMethodInsn(182, "java/nio/IntBuffer", "get", "(I)I", false);
        this.doIntegerNaCheck(mv, naLabel);
    }

    @Override
    public boolean mustCheckForIntegerNAs() {
        return true;
    }

    @Override
    public void appendToKey(StringBuilder key) {
        key.append("IBN");
    }

    public String toString() {
        return "x" + this.operandIndex;
    }
}

